/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.mixin.minecraft.i18n;

import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.api.fake.i18n.ServerPlayerLanguage;
import top.hendrixshen.magiclib.impl.i18n.minecraft.translation.MagicTranslation;
import top.hendrixshen.magiclib.util.MiscUtil;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
implements ServerPlayerLanguage {
    @Unique
    private String magiclib$language = "en_us";

    @Inject(method={"updateOptions(Lnet/minecraft/server/level/ClientInformation;)V"}, at={@At(value="HEAD")})
    private void preUpdateOptions(@NotNull ClientInformation clientInformation, CallbackInfo ci) {
        this.magiclib$language = clientInformation.language().toLowerCase(Locale.ROOT);
    }

    @Override
    public String magicLib$getLanguage() {
        return this.magiclib$language;
    }

    @ModifyVariable(method={"sendSystemMessage(Lnet/minecraft/network/chat/Component;Z)V"}, at=@At(value="HEAD"), argsOnly=true)
    private Component applyMagicTranslationToChatMessage(Component message) {
        if (message instanceof MutableComponent) {
            message = MagicTranslation.translate(MutableComponentCompat.of((MutableComponent)MiscUtil.cast(message)), (ServerPlayer)this).get();
        }
        return message;
    }
}

