/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.collect;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueContainer<T> {
    private static final ValueContainer<?> EMPTY = new ValueContainer<Object>(null, false, null);
    private final T value;
    private final boolean exist;
    @Nullable
    private final Throwable exception;

    @NotNull
    public static <T> ValueContainer<T> of(T value) {
        return new ValueContainer<T>(Objects.requireNonNull(value), true, null);
    }

    @NotNull
    public static <T> ValueContainer<T> ofNullable(T value) {
        return value == null ? ValueContainer.empty() : new ValueContainer<T>(value, true, null);
    }

    @NotNull
    public static <T> ValueContainer<T> empty() {
        ValueContainer<?> t = EMPTY;
        return t;
    }

    @NotNull
    public static <T> ValueContainer<T> exception(Throwable exception) {
        return new ValueContainer<Object>(null, false, exception);
    }

    public T get() {
        if (this.exist) {
            return this.value;
        }
        if (this.isException()) {
            assert (this.exception != null);
            throw this.exception;
        }
        throw new RuntimeException("No value present");
    }

    public boolean isException() {
        return this.exception != null;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(Consumer<T> action) {
        if (this.isPresent()) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isPresent()) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public ValueContainer<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isPresent()) {
            return predicate.test(this.value) ? this : ValueContainer.empty();
        }
        return this;
    }

    public <U> ValueContainer<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isPresent()) {
            return ValueContainer.ofNullable(mapper.apply(this.value));
        }
        return ValueContainer.empty();
    }

    public <U> ValueContainer<U> flatMap(Function<? super T, ? extends ValueContainer<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isPresent()) {
            ValueContainer<? extends U> r = mapper.apply(this.value);
            return Objects.requireNonNull(r);
        }
        return ValueContainer.empty();
    }

    public ValueContainer<T> or(Supplier<? extends ValueContainer<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        ValueContainer<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.value) : Stream.empty();
    }

    public T orElse(T other) {
        return this.isPresent() ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.value : supplier.get();
    }

    public T orElseThrow() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoSuchElementException("No value present");
    }

    public <E extends Throwable> T orElseThrow(Supplier<? extends E> exceptionSupplier) throws E {
        if (this.exist) {
            return this.value;
        }
        if (this.isException()) {
            assert (this.exception != null);
            throw this.exception;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @Generated
    public String toString() {
        return "ValueContainer(value=" + this.value + ", exist=" + this.isExist() + ", exception=" + this.getException() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueContainer)) {
            return false;
        }
        ValueContainer other = (ValueContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExist() != other.isExist()) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValueContainer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExist() ? 79 : 97);
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    @Generated
    private ValueContainer(T value, boolean exist, @Nullable Throwable exception) {
        this.value = value;
        this.exist = exist;
        this.exception = exception;
    }

    @Generated
    public boolean isExist() {
        return this.exist;
    }

    @Nullable
    @Generated
    public Throwable getException() {
        return this.exception;
    }
}

