/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.minecraft;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.MagicLib;

public class NetworkUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NbtStyle guessNbtStyle(@NotNull FriendlyByteBuf buf) {
        int n = buf.readableBytes();
        int prevReaderIndex = buf.readerIndex();
        try {
            if (n < 2) {
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            byte typeId = buf.readByte();
            if (typeId != 10) {
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            if (n == 2) {
                if (buf.readByte() == 0) {
                    NbtStyle nbtStyle = NbtStyle.MODERN;
                    return nbtStyle;
                }
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            byte[] bytes = new byte[2];
            buf.readBytes(bytes);
            if (bytes[0] == 0 && bytes[1] == 0) {
                NbtStyle nbtStyle = NbtStyle.LEGACY;
                return nbtStyle;
            }
            if (0 <= bytes[0] && bytes[0] < 13) {
                NbtStyle nbtStyle = NbtStyle.MODERN;
                return nbtStyle;
            }
        }
        finally {
            buf.readerIndex(prevReaderIndex);
        }
        return NbtStyle.UNKNOWN;
    }

    public static CompoundTag readNbtAuto(FriendlyByteBuf buf) {
        NbtStyle nbtStyle = NetworkUtil.guessNbtStyle(buf);
        return Objects.requireNonNull(NetworkUtil.readNbt(nbtStyle, buf));
    }

    public static void writeNbtWithFormat(FriendlyByteBuf buf, CompoundTag nbt) {
        buf.writeVarInt(NbtStyle.CURRENT.ordinal());
        buf.writeNbt((Tag)nbt);
    }

    public static CompoundTag readNbtWithFormat(FriendlyByteBuf buf) {
        int styleId = buf.readVarInt();
        NbtStyle nbtStyle = NbtStyle.values()[styleId];
        return Objects.requireNonNull(NetworkUtil.readNbt(nbtStyle, buf));
    }

    @Nullable
    private static CompoundTag readNbt(NbtStyle bufNbtStyle, FriendlyByteBuf buf) {
        if (bufNbtStyle == NbtStyle.UNKNOWN) {
            MagicLib.getLogger().debug("NetworkUtil.readNbt() called with unknown NbtStyle");
        }
        if ((NbtStyle.CURRENT != NbtStyle.LEGACY || bufNbtStyle != NbtStyle.MODERN) && NbtStyle.CURRENT == NbtStyle.MODERN && bufNbtStyle == NbtStyle.LEGACY) {
            int prevReaderIndex = buf.readerIndex();
            FriendlyByteBuf tweakedBuf = new FriendlyByteBuf(Unpooled.buffer());
            tweakedBuf.writeByte(buf.readByte());
            buf.readBytes(2);
            tweakedBuf.writeBytes((ByteBuf)buf);
            buf.readerIndex(prevReaderIndex);
            CompoundTag nbt = tweakedBuf.readNbt();
            int n = tweakedBuf.readerIndex();
            buf.readBytes(Math.max(0, n > 1 ? n + 2 : n));
            return nbt;
        }
        return buf.readNbt();
    }

    @Deprecated
    public static CompoundTag readNbt(FriendlyByteBuf buf) {
        NbtStyle nbtStyle = NetworkUtil.guessNbtStyle(buf);
        return NetworkUtil.readNbt(nbtStyle, buf);
    }

    public static enum NbtStyle {
        UNKNOWN,
        LEGACY,
        MODERN;

        public static final NbtStyle CURRENT;

        static {
            CURRENT = MODERN;
        }
    }
}

