/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.network.packet;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.server.level.ServerPlayer;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.network.packet.ClientboundPacketHandler;
import top.hendrixshen.magiclib.api.network.packet.PacketCodec;
import top.hendrixshen.magiclib.api.network.packet.PacketType;
import top.hendrixshen.magiclib.api.network.packet.ServerboundPacketHandler;
import top.hendrixshen.magiclib.impl.network.packet.MagicPacketRegistrationCenterHelper;
import top.hendrixshen.magiclib.impl.network.packet.MagicPacketRegistry;

public class MagicPackets {
    public static <P> void registerServerbound(PacketType<P> id, PacketCodec<P> codec, ServerboundPacketHandler<P> handler) {
        if (MagicPacketRegistrationCenterHelper.isTooLateForServerboundRegister()) {
            MagicLib.getLogger().warn("MagicLib receives an Serverbound packet register request with id {} too late", id);
        }
        MagicPacketRegistry.SERVERBOUND_GAME.register(id, codec, handler);
    }

    public static <P> void registerClientbound(PacketType<P> id, PacketCodec<P> codec, ClientboundPacketHandler<P> handler) {
        if (MagicPacketRegistrationCenterHelper.isTooLateForClientboundRegister()) {
            MagicLib.getLogger().warn("MagicLib receives an Clientbound packet register request with id {} too late", id);
        }
        MagicPacketRegistry.CLIENTBOUND_GAME.register(id, codec, handler);
    }

    public static <P> void registerDual(PacketType<P> id, PacketCodec<P> codec, ServerboundPacketHandler<P> serverboundHandler, ClientboundPacketHandler<P> clientboundHandler) {
        MagicPackets.registerServerbound(id, codec, serverboundHandler);
        MagicPackets.registerClientbound(id, codec, clientboundHandler);
    }

    public static <P> ServerboundCustomPayloadPacket createServerbound(PacketType<P> id, P packet) {
        return MagicPacketRegistry.SERVERBOUND_GAME.createPacket(id, packet);
    }

    public static <P> ClientboundCustomPayloadPacket createClientbound(PacketType<P> id, P packet) {
        return MagicPacketRegistry.CLIENTBOUND_GAME.createPacket(id, packet);
    }

    public static <P> void sendServerbound(PacketType<P> type, P buf) {
        MagicPackets.sendServerbound(MagicPackets.createServerbound(type, buf));
    }

    public static void sendServerbound(ServerboundCustomPayloadPacket customPayloadPacket) {
        if (Minecraft.m_91087_().m_91403_() != null) {
            Minecraft.m_91087_().m_91403_().m_104955_((Packet)customPayloadPacket);
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    public static void sendClientbound(ServerPlayer player, PacketType<FriendlyByteBuf> type, FriendlyByteBuf buf) {
        MagicPackets.sendClientbound(player, MagicPackets.createClientbound(type, buf));
    }

    public static void sendClientbound(ServerPlayer player, ClientboundCustomPayloadPacket packet) {
        player.f_8906_.m_141995_((Packet)packet);
    }
}

