/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.i18n.minecraft.translation;

import java.util.List;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.api.fake.i18n.ServerPlayerLanguage;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.impl.i18n.minecraft.translation.HookTranslationManager;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.StyleAccessor;
import top.hendrixshen.magiclib.util.CommonUtil;
import top.hendrixshen.magiclib.util.minecraft.ComponentUtil;

public class MagicTranslation {
    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text) {
        return MagicTranslation.translate(text, I18n.getCurrentLanguageCode());
    }

    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text, String lang) {
        return MagicTranslation.translateComponent(text, lang);
    }

    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text, ServerPlayer player) {
        return MagicTranslation.translate(text, ((ServerPlayerLanguage)player).magicLib$getLanguage());
    }

    @NotNull
    private static MutableComponentCompat translateComponent(@NotNull MutableComponentCompat text, @NotNull String lang) {
        return MutableComponentCompat.of(MagicTranslation.translateComponent(text.get(), lang));
    }

    private static BaseComponent translateComponent(BaseComponent text, @NotNull String lang) {
        boolean[] translationRequired = new boolean[]{false};
        MagicTranslation.forEachTranslationComponent(text, lang, (txt, msgKeyString) -> {
            translationRequired[0] = true;
            return txt;
        });
        if (!translationRequired[0]) {
            return text;
        }
        return MagicTranslation.forEachTranslationComponent(ComponentUtil.copy(text), lang, (txt, msgKeyString) -> {
            BaseComponent newText;
            String txtKey = txt.m_131328_();
            Object[] txtArgs = txt.m_131329_();
            if (msgKeyString == null) {
                MagicLib.getLogger().warn("MagicTranslation: Unknown translation key {}", (Object)txtKey);
                return txt;
            }
            try {
                newText = ComponentUtil.format(msgKeyString, txtArgs);
            }
            catch (IllegalArgumentException e) {
                newText = ComponentUtil.simple(msgKeyString);
            }
            newText.m_7360_().addAll(txt.m_7360_());
            newText.m_6270_(txt.m_7383_());
            return newText;
        });
    }

    @NotNull
    private static BaseComponent forEachTranslationComponent(BaseComponent text, @NotNull String lang, ComponentModifier modifier) {
        BaseComponent newHoverText;
        BaseComponent oldHoverText;
        HoverEvent hoverEvent;
        BaseComponent newText;
        int i;
        if (ComponentUtil.getTextContent(text) instanceof TranslatableComponent) {
            TranslatableComponent translatableText = (TranslatableComponent)ComponentUtil.getTextContent(text);
            Object[] args = translatableText.m_131329_();
            for (i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof BaseComponent) || (newText = MagicTranslation.forEachTranslationComponent((BaseComponent)arg, lang, modifier)) == arg) continue;
                args[i] = newText;
            }
            if (HookTranslationManager.getInstance().isNamespaceRegistered(translatableText.m_131328_())) {
                String msgKeyString = I18n.trByCode(lang, translatableText.m_131328_());
                text = modifier.apply(translatableText, msgKeyString);
            }
        }
        if ((hoverEvent = ((StyleAccessor)text.m_7383_()).getHoverEvent()) != null && (oldHoverText = CommonUtil.make(() -> {
            Object hoverEventText = hoverEvent.m_130823_(hoverEvent.m_130820_());
            if (hoverEvent.m_130820_() == HoverEvent.Action.f_130831_ && hoverEventText instanceof BaseComponent) {
                return (BaseComponent)hoverEventText;
            }
            return null;
        })) != null && (newHoverText = MagicTranslation.forEachTranslationComponent(oldHoverText, lang, modifier)) != oldHoverText) {
            ComponentUtil.hover(text, newHoverText);
        }
        List siblings = text.m_7360_();
        for (i = 0; i < siblings.size(); ++i) {
            Component sibling = (Component)siblings.get(i);
            newText = MagicTranslation.forEachTranslationComponent((BaseComponent)sibling, lang, modifier);
            if (newText == sibling) continue;
            siblings.set(i, newText);
        }
        return text;
    }

    @FunctionalInterface
    private static interface ComponentModifier {
        public BaseComponent apply(TranslatableComponent var1, @Nullable String var2);
    }
}

