/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigHandler;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigManager;
import top.hendrixshen.magiclib.api.malilib.config.migration.ConfigMigrator;
import top.hendrixshen.magiclib.impl.malilib.config.ConfigContainer;
import top.hendrixshen.magiclib.impl.malilib.config.statistic.ConfigStatisticSaver;
import top.hendrixshen.magiclib.util.FileUtil;
import top.hendrixshen.magiclib.util.serializable.JsonSaveAble;

public class MagicConfigHandlerImpl
implements MagicConfigHandler {
    private final MagicConfigManager configManager;
    private final String identifier;
    private final File configFile;
    private final int handlerVersion;
    private JsonObject loadedJson = new JsonObject();
    private final GlobalConfig globalConfig = new GlobalConfig();
    private final Map<String, JsonSaveAble> internalDataSavers = Maps.newHashMap();
    private final Map<String, JsonSaveAble> externalDataSavers = Maps.newHashMap();
    private final List<ConfigMigrator> migrators = Lists.newArrayList();
    @Nullable
    private Consumer<MagicConfigHandler> preDeserializeCallback;
    @Nullable
    private Consumer<MagicConfigHandler> postDeserializeCallback;
    @Nullable
    private Consumer<MagicConfigHandler> preSerializeCallback;
    @Nullable
    private Consumer<MagicConfigHandler> postSerializeCallback;

    public MagicConfigHandlerImpl(@NotNull MagicConfigManager configManager, int handlerVersion) {
        this.identifier = configManager.getIdentifier();
        this.configFile = FileUtil.getConfigFile(this.identifier);
        this.configManager = configManager;
        this.handlerVersion = handlerVersion;
        this.getGlobalConfig().setConfigVersion(handlerVersion);
        this.internalDataSavers.put("global", this.globalConfig);
        this.internalDataSavers.put("config_gui", this.configManager.getGuiSetting());
        this.internalDataSavers.put("configStatistic", new ConfigStatisticSaver(this.configManager));
    }

    @Override
    public boolean registerExternalData(String namespace, JsonSaveAble data) {
        if (this.externalDataSavers.containsKey(namespace)) {
            return false;
        }
        this.externalDataSavers.put(namespace, data);
        return true;
    }

    @Override
    public boolean unregisterExternalData(String namespace) {
        if (!this.externalDataSavers.containsKey(namespace)) {
            return false;
        }
        this.externalDataSavers.remove(namespace);
        return true;
    }

    public boolean registerMigrator(ConfigMigrator migrator) {
        return this.registerMigrator(migrator, false);
    }

    public boolean registerMigrator(ConfigMigrator migrator, boolean priority) {
        if (migrator == null) {
            return false;
        }
        if (priority) {
            this.migrators.add(0, migrator);
        } else {
            this.migrators.add(migrator);
        }
        return true;
    }

    @Override
    public int getConfigVersion() {
        return this.globalConfig.configVersion;
    }

    public void loadConfig(JsonObject root) {
        for (String category2 : this.configManager.getCategories().stream().filter(category -> !category.equals("all")).collect(Collectors.toList())) {
            List configs = this.configManager.getContainers(category2).stream().map(ConfigContainer::getConfig).collect(Collectors.toList());
            ConfigUtils.readConfigBase((JsonObject)root, (String)category2, configs);
        }
    }

    public void saveConfig(JsonObject root) {
        for (String category2 : this.configManager.getCategories().stream().filter(category -> !category.equals("all")).collect(Collectors.toList())) {
            List configs = this.configManager.getContainers(category2).stream().map(ConfigContainer::getConfig).collect(Collectors.toList());
            ConfigUtils.writeConfigBase((JsonObject)root, (String)category2, configs);
        }
    }

    public final void loadFromJson(@NotNull JsonObject root) {
        this.loadedJson = new JsonParser().parse(root.toString()).getAsJsonObject();
        boolean migrated = false;
        for (ConfigMigrator migrator : this.migrators) {
            if (!migrator.shouldMigrate(this)) continue;
            migrated |= migrator.migrate(this);
        }
        if (this.preDeserializeCallback != null) {
            this.preDeserializeCallback.accept(this);
        }
        this.loadConfig(this.loadedJson);
        this.loadInternal(this.loadedJson);
        this.loadExternal(this.loadedJson);
        if (this.postDeserializeCallback != null) {
            this.postDeserializeCallback.accept(this);
        }
        this.configManager.onConfigLoaded();
        if (migrated) {
            this.save();
        }
    }

    public final void saveToJson() {
        if (this.preSerializeCallback != null) {
            this.preSerializeCallback.accept(this);
        }
        this.saveConfig(this.loadedJson);
        this.saveInternal(this.loadedJson);
        this.saveExternal(this.loadedJson);
        if (this.postSerializeCallback != null) {
            this.postSerializeCallback.accept(this);
        }
    }

    private void loadExternal(JsonObject jsonObject) {
        this.loadInjected(jsonObject, "external", this.externalDataSavers);
    }

    private void saveExternal(JsonObject jsonObject) {
        this.saveInjected(jsonObject, "external", this.externalDataSavers);
    }

    private void loadInternal(JsonObject jsonObject) {
        this.loadInjected(jsonObject, "internal", this.internalDataSavers);
    }

    private void saveInternal(JsonObject jsonObject) {
        this.saveInjected(jsonObject, "internal", this.internalDataSavers);
    }

    private void loadInjected(JsonObject jsonObject, String namespace, Map<String, JsonSaveAble> mapping) {
        JsonObject injected = JsonUtils.getNestedObject((JsonObject)jsonObject, (String)namespace, (boolean)false);
        if (injected != null) {
            mapping.forEach((name, jsonSaveAble) -> {
                JsonObject object = JsonUtils.getNestedObject((JsonObject)injected, (String)name, (boolean)false);
                if (object != null) {
                    jsonSaveAble.loadFromJsonSafe(object);
                }
            });
        }
    }

    private void saveInjected(JsonObject jsonObject, String namespace, @NotNull Map<String, JsonSaveAble> mapping) {
        JsonObject injected = JsonUtils.getNestedObject((JsonObject)jsonObject, (String)namespace, (boolean)true);
        assert (injected != null);
        mapping.forEach((name, jsonSaveAble) -> injected.add(name, (JsonElement)jsonSaveAble.dumpToJson()));
    }

    public final void load() {
        JsonElement element;
        JsonObject root = null;
        if (this.configFile.exists() && this.configFile.isFile() && this.configFile.canRead() && (element = JsonUtils.parseJsonFile((File)this.configFile)) != null && element.isJsonObject()) {
            root = element.getAsJsonObject();
        }
        if (root != null) {
            this.loadFromJson(root);
        }
    }

    public final void save() {
        this.saveToJson();
        JsonUtils.writeJsonToFile((JsonObject)this.loadedJson, (File)this.configFile);
    }

    @Override
    @Generated
    public MagicConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Generated
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    @Generated
    public int getHandlerVersion() {
        return this.handlerVersion;
    }

    @Override
    @Generated
    public JsonObject getLoadedJson() {
        return this.loadedJson;
    }

    @Generated
    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    @Override
    @Generated
    public void setPreDeserializeCallback(@Nullable Consumer<MagicConfigHandler> preDeserializeCallback) {
        this.preDeserializeCallback = preDeserializeCallback;
    }

    @Override
    @Generated
    public void setPostDeserializeCallback(@Nullable Consumer<MagicConfigHandler> postDeserializeCallback) {
        this.postDeserializeCallback = postDeserializeCallback;
    }

    @Override
    @Generated
    public void setPreSerializeCallback(@Nullable Consumer<MagicConfigHandler> preSerializeCallback) {
        this.preSerializeCallback = preSerializeCallback;
    }

    @Override
    @Generated
    public void setPostSerializeCallback(@Nullable Consumer<MagicConfigHandler> postSerializeCallback) {
        this.postSerializeCallback = postSerializeCallback;
    }

    private static class GlobalConfig
    implements JsonSaveAble {
        private int configVersion = 0;

        private GlobalConfig() {
        }

        @Override
        public void dumpToJson(@NotNull JsonObject jsonObject) {
            jsonObject.addProperty("config_version", (Number)this.configVersion);
        }

        @Override
        public void loadFromJson(@NotNull JsonObject jsonObject) {
            this.configVersion = jsonObject.get("config_version").getAsInt();
        }

        @Generated
        public int getConfigVersion() {
            return this.configVersion;
        }

        @Generated
        public void setConfigVersion(int configVersion) {
            this.configVersion = configVersion;
        }
    }
}

