/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.mixin.extension.jikuTsuiho;

import com.google.common.collect.Sets;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.util.Annotations;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.mixin.annotation.JikuTsuiho;
import top.hendrixshen.magiclib.api.mixin.extension.jikuTsuiho.info.MixinClassInfo;
import top.hendrixshen.magiclib.api.mixin.extension.jikuTsuiho.info.MixinFieldInfo;
import top.hendrixshen.magiclib.api.mixin.extension.jikuTsuiho.info.MixinMethodInfo;
import top.hendrixshen.magiclib.api.mixin.extension.jikuTsuiho.predicate.MixinEraserClass;
import top.hendrixshen.magiclib.api.mixin.extension.jikuTsuiho.predicate.MixinEraserField;
import top.hendrixshen.magiclib.api.mixin.extension.jikuTsuiho.predicate.MixinEraserMethod;
import top.hendrixshen.magiclib.impl.mixin.extension.jikuTsuiho.InternalTsuihoField;
import top.hendrixshen.magiclib.impl.mixin.extension.jikuTsuiho.InternalTsuihoMethod;
import top.hendrixshen.magiclib.util.mixin.MixinUtil;

public class MixinEraserManager {
    private static final Set<MixinEraserClass> jikuTsuihoClasses = Sets.newHashSet();
    private static final Set<MixinEraserField> jikuTsuihoFields = Sets.newHashSet();
    private static final Set<MixinEraserMethod> jikuTsuihoMethods = Sets.newHashSet();

    public static boolean shouldTsuiho(MixinClassInfo info) {
        return jikuTsuihoClasses.stream().anyMatch(eraser -> eraser.shouldErase(info));
    }

    public static boolean shouldTsuiho(MixinFieldInfo info) {
        return jikuTsuihoFields.stream().anyMatch(eraser -> eraser.shouldErase(info));
    }

    public static boolean shouldTsuiho(MixinMethodInfo info) {
        return jikuTsuihoMethods.stream().anyMatch(eraser -> eraser.shouldErase(info));
    }

    public static void register(MixinEraserClass eraser) {
        jikuTsuihoClasses.add(eraser);
        MagicLib.getLogger().debug("Registered mixin class tsuiho: {}", (Object)eraser.getClass().getName());
    }

    public static void register(MixinEraserField eraser) {
        jikuTsuihoFields.add(eraser);
        MagicLib.getLogger().debug("Registered mixin method tsuiho: {}", (Object)eraser.getClass().getName());
    }

    public static void register(MixinEraserMethod eraser) {
        jikuTsuihoMethods.add(eraser);
        MagicLib.getLogger().debug("Registered mixin field tsuiho: {}", (Object)eraser.getClass().getName());
    }

    public static void parseFromClass(@NotNull Class<?> clazz) {
        String mixinClassName;
        AnnotationNode annotation;
        ClassNode classNode = MixinUtil.getClassNode(clazz.getName());
        if (classNode == null) {
            throw new RuntimeException("Failed to parse class: " + clazz.getName());
        }
        int fields = 0;
        int methods = 0;
        for (FieldNode field : classNode.fields) {
            annotation = Annotations.getInvisible((FieldNode)field, JikuTsuiho.class);
            if (annotation == null) continue;
            mixinClassName = (String)Annotations.getValue((AnnotationNode)annotation, (String)"mixinClassName");
            String fieldName = field.name;
            String fieldDesc = field.desc;
            jikuTsuihoFields.add(new InternalTsuihoField(mixinClassName, fieldName, fieldDesc));
            ++fields;
        }
        for (MethodNode method : classNode.methods) {
            annotation = Annotations.getInvisible((MethodNode)method, JikuTsuiho.class);
            if (annotation == null) continue;
            mixinClassName = (String)Annotations.getValue((AnnotationNode)annotation, (String)"mixinClassName");
            Type injectType = (Type)Annotations.getValue((AnnotationNode)annotation, (String)"injectType");
            String methodName = method.name;
            String methodDesc = method.desc;
            jikuTsuihoMethods.add(new InternalTsuihoMethod(mixinClassName, injectType.getDescriptor(), methodName, methodDesc));
            ++methods;
        }
        MagicLib.getLogger().debug("Parsed {} fields and {} methods from {}", (Object)fields, (Object)methods, (Object)clazz.getName());
    }
}

