/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util;

import java.lang.annotation.Annotation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public class ASMUtil {
    @NotNull
    public static ValueContainer<AnnotationNode> getInVisibleAnnotations(@NotNull MethodNode methodNode, Class<? extends Annotation> annotationClass) {
        return ASMUtil.getAnnotations(methodNode.invisibleAnnotations, Type.getDescriptor(annotationClass));
    }

    @NotNull
    public static ValueContainer<AnnotationNode> getVisibleAnnotations(@NotNull MethodNode methodNode, Class<? extends Annotation> annotationClass) {
        return ASMUtil.getAnnotations(methodNode.visibleAnnotations, Type.getDescriptor(annotationClass));
    }

    @NotNull
    public static ValueContainer<AnnotationNode> getInvisibleAnnotations(@NotNull ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return ASMUtil.getAnnotations(classNode.invisibleAnnotations, Type.getDescriptor(annotationClass));
    }

    @NotNull
    public static ValueContainer<AnnotationNode> getVisibleAnnotations(@NotNull ClassNode classNode, Class<? extends Annotation> annotationClass) {
        return ASMUtil.getAnnotations(classNode.visibleAnnotations, Type.getDescriptor(annotationClass));
    }

    @NotNull
    public static ValueContainer<AnnotationNode> getAnnotations(List<AnnotationNode> annotations, String annotationType) {
        if (annotations == null) {
            return ValueContainer.empty();
        }
        for (AnnotationNode annotation : annotations) {
            if (!annotationType.equals(annotation.desc)) continue;
            return ValueContainer.of(annotation);
        }
        return ValueContainer.empty();
    }
}

