/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.minecraft;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.chat.TranslatableFormatException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ClickEventCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ComponentCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.HoverEventCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.StyleCompat;
import top.hendrixshen.magiclib.impl.compat.minecraft.world.level.dimension.DimensionWrapper;
import top.hendrixshen.magiclib.impl.i18n.minecraft.translation.Translator;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.DyeColorAccessor;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.TranslatableComponentAccessor;
import top.hendrixshen.magiclib.util.minecraft.ResourceLocationUtil;
import top.hendrixshen.magiclib.util.minecraft.TextUtil;

public class ComponentUtil {
    private static final Translator translator = new Translator("magiclib.util.minecraft");
    private static final ImmutableMap<DyeColor, Consumer<BaseComponent>> DYE_COLOR_APPLIER = (ImmutableMap)Util.m_137537_(() -> {
        HashMap map = Maps.newHashMap();
        map.put(DyeColor.WHITE, ChatFormatting.WHITE);
        map.put(DyeColor.LIGHT_GRAY, ChatFormatting.GRAY);
        map.put(DyeColor.GRAY, ChatFormatting.DARK_GRAY);
        map.put(DyeColor.BLACK, ChatFormatting.BLACK);
        map.put(DyeColor.RED, ChatFormatting.RED);
        map.put(DyeColor.YELLOW, ChatFormatting.YELLOW);
        map.put(DyeColor.LIME, ChatFormatting.GREEN);
        map.put(DyeColor.GREEN, ChatFormatting.DARK_GREEN);
        map.put(DyeColor.CYAN, ChatFormatting.DARK_AQUA);
        map.put(DyeColor.LIGHT_BLUE, ChatFormatting.AQUA);
        map.put(DyeColor.BLUE, ChatFormatting.DARK_BLUE);
        map.put(DyeColor.PURPLE, ChatFormatting.DARK_PURPLE);
        map.put(DyeColor.MAGENTA, ChatFormatting.LIGHT_PURPLE);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        map.forEach((dyeColor, fmt) -> builder.put(dyeColor, text -> ComponentUtil.formatting(text, fmt)));
        Arrays.stream(DyeColor.values()).filter(dyeColor -> !map.containsKey(dyeColor)).forEach(dyeColor -> builder.put(dyeColor, text -> {
            TextColor color = TextColor.m_131266_((int)((DyeColorAccessor)dyeColor).magiclib$getTextColor());
            text.m_6270_(text.m_7383_().m_131148_(color));
        }));
        return builder.build();
    });
    private static final ImmutableMap<DimensionWrapper, BaseComponent> DIMENSION_NAME = ImmutableMap.of((Object)DimensionWrapper.OVERWORLD, (Object)ComponentUtil.tr("createWorld.customize.preset.overworld", new Object[0]), (Object)DimensionWrapper.NETHER, (Object)ComponentUtil.tr("advancements.nether.root.title", new Object[0]), (Object)DimensionWrapper.THE_END, (Object)ComponentUtil.tr("advancements.end.root.title", new Object[0]));

    public static BaseComponent getTextContent(BaseComponent text) {
        return text;
    }

    public static BaseComponent getTextContent(@NotNull MutableComponentCompat mutableComponentCompat) {
        return ComponentUtil.getTextContent(mutableComponentCompat.get());
    }

    @NotNull
    public static BaseComponent compose(Object ... objects) {
        BaseComponent literal = ComponentUtil.empty();
        for (Object o : objects) {
            if (o instanceof MutableComponentCompat) {
                literal.m_7220_((Component)((MutableComponentCompat)o).get());
                continue;
            }
            if (o instanceof BaseComponent) {
                literal.m_7220_((Component)((BaseComponent)o));
                continue;
            }
            literal.m_130946_(o.toString());
        }
        return literal;
    }

    @NotNull
    public static MutableComponentCompat composeCompat(Object ... objects) {
        return MutableComponentCompat.of(ComponentUtil.compose(objects));
    }

    @NotNull
    public static BaseComponent simple(@NotNull Object text) {
        return ComponentCompat.literal(text.toString());
    }

    @NotNull
    public static MutableComponentCompat simpleCompat(@NotNull Object text) {
        return ComponentCompat.literalCompat(text.toString());
    }

    @NotNull
    public static BaseComponent simple(Object text, ChatFormatting ... chatFormattings) {
        return ComponentUtil.formatting(ComponentUtil.simple(text), chatFormattings);
    }

    @NotNull
    public static MutableComponentCompat simpleCompat(Object text, ChatFormatting ... chatFormattings) {
        return ComponentUtil.formattingCompat(ComponentUtil.simpleCompat(text), chatFormattings);
    }

    @NotNull
    public static BaseComponent empty() {
        return ComponentUtil.simple("");
    }

    @NotNull
    public static MutableComponentCompat emptyCompat() {
        return ComponentUtil.simpleCompat("");
    }

    @NotNull
    public static BaseComponent newLine() {
        return ComponentUtil.simple("\n");
    }

    @NotNull
    public static MutableComponentCompat newLineCompat() {
        return ComponentUtil.simpleCompat("\n");
    }

    public static BaseComponent colored(BaseComponent text, DyeColor value) {
        Consumer consumer = (Consumer)DYE_COLOR_APPLIER.get((Object)value);
        if (consumer != null) {
            consumer.accept(text);
        }
        return text;
    }

    @NotNull
    public static MutableComponentCompat coloredCompat(@NotNull MutableComponentCompat text, DyeColor value) {
        ComponentUtil.colored(text.get());
        return text;
    }

    public static BaseComponent colored(BaseComponent text, Object value) {
        ChatFormatting color = null;
        if (Boolean.TRUE.equals(value)) {
            color = ChatFormatting.GREEN;
        } else if (Boolean.FALSE.equals(value)) {
            color = ChatFormatting.RED;
        }
        if (value instanceof Number) {
            color = ChatFormatting.GOLD;
        }
        if (color != null) {
            ComponentUtil.formatting(text, color);
        }
        return text;
    }

    @NotNull
    public static MutableComponentCompat coloredCompat(@NotNull MutableComponentCompat text, Object value) {
        ComponentUtil.colored(text.get(), value);
        return text;
    }

    public static BaseComponent colored(Object value) {
        return ComponentUtil.colored(ComponentUtil.simple(value), value);
    }

    @NotNull
    public static MutableComponentCompat coloredCompat(Object value) {
        return ComponentUtil.coloredCompat(ComponentUtil.simpleCompat(value), value);
    }

    public static BaseComponent property(Property<?> property, Object value) {
        return ComponentUtil.colored(ComponentUtil.simple(TextUtil.property(property, value)), value);
    }

    public static MutableComponentCompat propertyCompat(Property<?> property, Object value) {
        return ComponentUtil.coloredCompat(ComponentUtil.simpleCompat(TextUtil.property(property, value)), value);
    }

    @NotNull
    public static BaseComponent tr(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof ComponentCompat)) continue;
            args[i] = ((ComponentCompat)args[i]).get();
        }
        return ComponentCompat.translatable(key, args);
    }

    @NotNull
    public static MutableComponentCompat trCompat(String key, Object ... args) {
        return MutableComponentCompat.of(ComponentUtil.tr(key, args));
    }

    @NotNull
    public static BaseComponent fancy(BaseComponent displayText, BaseComponent hoverText, ClickEvent clickEvent) {
        BaseComponent text = ComponentUtil.copy(displayText);
        if (hoverText != null) {
            ComponentUtil.hover(text, hoverText);
        }
        if (clickEvent != null) {
            ComponentUtil.click(text, clickEvent);
        }
        return text;
    }

    @NotNull
    public static MutableComponentCompat fancyCompat(@NotNull MutableComponentCompat displayText, MutableComponentCompat hoverText, ClickEventCompat clickEvent) {
        return MutableComponentCompat.of(ComponentUtil.fancy(displayText.get(), hoverText == null ? null : hoverText.get(), clickEvent == null ? null : (ClickEvent)clickEvent.get()));
    }

    @NotNull
    public static BaseComponent join(BaseComponent joiner, @NotNull Iterable<BaseComponent> items) {
        BaseComponent text = ComponentUtil.empty();
        boolean first = true;
        for (BaseComponent item : items) {
            if (!first) {
                text.m_7220_((Component)joiner);
            }
            first = false;
            text.m_7220_((Component)item);
        }
        return text;
    }

    @NotNull
    public static MutableComponentCompat joinCompat(MutableComponentCompat joiner, @NotNull Iterable<MutableComponentCompat> items) {
        return MutableComponentCompat.of(ComponentUtil.join(joiner.get(), StreamSupport.stream(items.spliterator(), false).map(MutableComponentCompat::get).collect(Collectors.toList())));
    }

    @NotNull
    public static BaseComponent join(BaseComponent joiner, BaseComponent ... items) {
        return ComponentUtil.join(joiner, Arrays.asList(items));
    }

    @NotNull
    public static MutableComponentCompat joinCompat(MutableComponentCompat joiner, MutableComponentCompat ... items) {
        return ComponentUtil.joinCompat(joiner, Arrays.asList(items));
    }

    @NotNull
    public static BaseComponent joinLines(Iterable<BaseComponent> items) {
        return ComponentUtil.join(ComponentUtil.newLine(), items);
    }

    @NotNull
    public static MutableComponentCompat joinLinesCompat(Iterable<MutableComponentCompat> items) {
        return ComponentUtil.joinCompat(ComponentUtil.newLineCompat(), items);
    }

    @NotNull
    public static BaseComponent joinLines(BaseComponent ... items) {
        return ComponentUtil.join(ComponentUtil.newLine(), items);
    }

    @NotNull
    public static MutableComponentCompat joinLinesCompat(MutableComponentCompat ... items) {
        return ComponentUtil.joinCompat(ComponentUtil.newLineCompat(), items);
    }

    @NotNull
    public static BaseComponent format(String formatter, Object ... args) {
        TranslatableComponentAccessor dummy = (TranslatableComponentAccessor)ComponentUtil.tr(formatter, args);
        try {
            dummy.magiclib$getDecomposedParts().clear();
            dummy.magiclib$invokeDecomposeTemplate(formatter);
            return ComponentUtil.compose(dummy.magiclib$getDecomposedParts().stream().map(formattedText -> {
                if (formattedText instanceof BaseComponent) {
                    return formattedText;
                }
                return ComponentUtil.simple(formattedText.getString());
            }).toArray());
        }
        catch (TranslatableFormatException e) {
            throw new IllegalArgumentException(formatter);
        }
    }

    @NotNull
    public static MutableComponentCompat formatCompat(String formatter, Object ... args) {
        return MutableComponentCompat.of(ComponentUtil.format(formatter, args));
    }

    @NotNull
    public static BaseComponent bool(boolean bool) {
        return ComponentUtil.simple(String.valueOf(bool), bool ? ChatFormatting.GREEN : ChatFormatting.RED);
    }

    @NotNull
    public static MutableComponentCompat boolCompat(boolean bool) {
        return MutableComponentCompat.of(ComponentUtil.bool(bool));
    }

    private static BaseComponent getTeleportHint(BaseComponent dest) {
        return translator.tr("teleport_hint.hover", dest);
    }

    private static MutableComponentCompat getTeleportHintCompat(MutableComponentCompat dest) {
        return translator.trCompat("teleport_hint.hover", dest);
    }

    @NotNull
    private static BaseComponent coordinate(@Nullable DimensionWrapper dim, String posStr, String command) {
        BaseComponent hoverText = ComponentUtil.empty();
        hoverText.m_7220_((Component)ComponentUtil.getTeleportHint(ComponentUtil.simple(posStr)));
        if (dim != null) {
            hoverText.m_130946_("\n");
            hoverText.m_7220_((Component)translator.tr("teleport_hint.dimension", new Object[0]));
            hoverText.m_130946_(": ");
            hoverText.m_7220_((Component)ComponentUtil.dimension(dim));
        }
        return ComponentUtil.fancy(ComponentUtil.simple(posStr), hoverText, ClickEventCompat.suggestCommand(command));
    }

    @NotNull
    private static MutableComponentCompat coordinateCompat(@Nullable DimensionWrapper dim, String posStr, String command) {
        return MutableComponentCompat.of(ComponentUtil.coordinate(dim, posStr, command));
    }

    @NotNull
    public static BaseComponent coordinate(Vec3 pos, DimensionWrapper dim) {
        return ComponentUtil.coordinate(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static MutableComponentCompat coordinateCompat(Vec3 pos, DimensionWrapper dim) {
        return ComponentUtil.coordinateCompat(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static BaseComponent coordinate(Vec3i pos, DimensionWrapper dim) {
        return ComponentUtil.coordinate(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static MutableComponentCompat coordinateCompat(Vec3i pos, DimensionWrapper dim) {
        return ComponentUtil.coordinateCompat(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static BaseComponent coordinate(ChunkPos pos, DimensionWrapper dim) {
        return ComponentUtil.coordinate(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static MutableComponentCompat coordinateCompat(ChunkPos pos, DimensionWrapper dim) {
        return ComponentUtil.coordinateCompat(dim, TextUtil.coordinate(pos), TextUtil.tp(pos, dim));
    }

    @NotNull
    public static BaseComponent coordinate(Vec3 pos) {
        return ComponentUtil.coordinate(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    public static MutableComponentCompat coordinateCompat(Vec3 pos) {
        return ComponentUtil.coordinateCompat(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    public static BaseComponent coordinate(Vec3i pos) {
        return ComponentUtil.coordinate(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    public static MutableComponentCompat coordinateCompat(Vec3i pos) {
        return ComponentUtil.coordinateCompat(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    public static BaseComponent coordinate(ChunkPos pos) {
        return ComponentUtil.coordinate(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    public static MutableComponentCompat coordinateCompat(ChunkPos pos) {
        return ComponentUtil.coordinateCompat(null, TextUtil.coordinate(pos), TextUtil.tp(pos));
    }

    @NotNull
    private static BaseComponent vector(String displayText, String detailedText) {
        return ComponentUtil.fancy(ComponentUtil.simple(displayText), ComponentUtil.simple(detailedText), ClickEventCompat.suggestCommand(detailedText));
    }

    @NotNull
    public static BaseComponent vector(Vec3 vec) {
        return ComponentUtil.vector(TextUtil.vector(vec), TextUtil.vector(vec, 6));
    }

    @NotNull
    public static MutableComponentCompat vectorCompat(Vec3 vec) {
        return MutableComponentCompat.of(ComponentUtil.vector(vec));
    }

    @NotNull
    public static BaseComponent entityType(@NotNull EntityType<?> entityType) {
        return (BaseComponent)entityType.m_20676_();
    }

    @NotNull
    public static MutableComponentCompat entityTypeCompat(@NotNull EntityType<?> entityType) {
        return MutableComponentCompat.of(ComponentUtil.entityType(entityType));
    }

    @NotNull
    public static BaseComponent entityType(@NotNull Entity entity) {
        return ComponentUtil.entityType(entity.m_6095_());
    }

    @NotNull
    public static MutableComponentCompat entityTypeCompat(@NotNull Entity entity) {
        return ComponentUtil.entityTypeCompat(entity.m_6095_());
    }

    @NotNull
    public static BaseComponent entity(Entity entity) {
        BaseComponent entityBaseName = ComponentUtil.entityType(entity);
        BaseComponent entityDisplayName = (BaseComponent)entity.m_7755_();
        BaseComponent hoverText = ComponentUtil.compose(translator.tr("entity_type", entityBaseName, ComponentUtil.simple(EntityType.m_20613_((EntityType)entity.m_6095_()).toString())), ComponentUtil.newLine(), ComponentUtil.getTeleportHint(entityDisplayName));
        return ComponentUtil.fancy(entityDisplayName, hoverText, ClickEventCompat.suggestCommand(TextUtil.tp(entity)));
    }

    @NotNull
    public static MutableComponentCompat entityCompat(Entity entity) {
        return MutableComponentCompat.of(ComponentUtil.entity(entity));
    }

    @NotNull
    public static BaseComponent attribute(@NotNull Attribute attribute) {
        return ComponentUtil.tr(attribute.m_22087_(), new Object[0]);
    }

    @NotNull
    public static MutableComponentCompat attributeCompat(@NotNull Attribute attribute) {
        return MutableComponentCompat.of(ComponentUtil.attribute(attribute));
    }

    public static BaseComponent dimension(DimensionWrapper dim) {
        BaseComponent dimText = (BaseComponent)DIMENSION_NAME.get((Object)dim);
        return dimText != null ? ComponentUtil.copy(dimText) : ComponentUtil.simple(dim.getResourceLocationString());
    }

    public static MutableComponentCompat dimensionCompat(DimensionWrapper dim) {
        return MutableComponentCompat.of(ComponentUtil.dimension(dim));
    }

    @NotNull
    public static BaseComponent getColoredDimensionSymbol(@NotNull DimensionWrapper dimensionType) {
        if (dimensionType.equals(DimensionWrapper.OVERWORLD)) {
            return ComponentUtil.simple("O", ChatFormatting.DARK_GREEN);
        }
        if (dimensionType.equals(DimensionWrapper.NETHER)) {
            return ComponentUtil.simple("N", ChatFormatting.DARK_RED);
        }
        if (dimensionType.equals(DimensionWrapper.THE_END)) {
            return ComponentUtil.simple("E", ChatFormatting.DARK_PURPLE);
        }
        return ComponentUtil.simple(dimensionType.getResourceLocationString().toUpperCase().substring(0, 1));
    }

    @NotNull
    public static MutableComponentCompat getColoredDimensionSymbolCompat(@NotNull DimensionWrapper dimensionType) {
        return MutableComponentCompat.of(ComponentUtil.getColoredDimensionSymbol(dimensionType));
    }

    @NotNull
    public static BaseComponent block(@NotNull Block block) {
        return ComponentUtil.hover(ComponentUtil.tr(block.m_7705_(), new Object[0]), ComponentUtil.simple(TextUtil.block(block)));
    }

    @NotNull
    public static MutableComponentCompat blockCompat(@NotNull Block block) {
        return MutableComponentCompat.of(ComponentUtil.block(block));
    }

    @NotNull
    public static BaseComponent block(@NotNull BlockState blockState) {
        ArrayList hovers = Lists.newArrayList();
        hovers.add(ComponentUtil.simple(TextUtil.block(blockState.m_60734_())));
        for (Property property : blockState.m_61147_()) {
            hovers.add(ComponentUtil.compose(ComponentUtil.simple(property.m_61708_()), ComponentUtil.simple(" : ").m_130938_(style -> style.m_131140_(ChatFormatting.GRAY)), ComponentUtil.property(property, blockState.m_61143_(property))));
        }
        return ComponentUtil.fancy(ComponentUtil.block(blockState.m_60734_()), ComponentUtil.join(ComponentUtil.newLine(), hovers.toArray(new BaseComponent[0])), ClickEventCompat.suggestCommand(TextUtil.block(blockState)));
    }

    @NotNull
    public static MutableComponentCompat blockCompat(@NotNull BlockState blockState) {
        return MutableComponentCompat.of(ComponentUtil.block(blockState));
    }

    @NotNull
    public static BaseComponent fluid(@NotNull Fluid fluid) {
        return ComponentUtil.hover(ComponentUtil.block(fluid.m_76145_().m_76188_().m_60734_()), ComponentUtil.simple(ResourceLocationUtil.id(fluid).toString()));
    }

    @NotNull
    public static MutableComponentCompat fluidCompat(@NotNull Fluid fluid) {
        return MutableComponentCompat.of(ComponentUtil.fluid(fluid));
    }

    @NotNull
    public static BaseComponent fluid(@NotNull FluidState fluid) {
        return ComponentUtil.fluid(fluid.m_76152_());
    }

    @NotNull
    public static MutableComponentCompat fluidCompat(@NotNull FluidState fluid) {
        return ComponentUtil.fluidCompat(fluid.m_76152_());
    }

    @NotNull
    public static BaseComponent blockEntity(@NotNull BlockEntity blockEntity) {
        ResourceLocation id = ResourceLocationUtil.id(blockEntity.m_58903_());
        return ComponentUtil.simple(id != null ? id.toString() : blockEntity.getClass().getSimpleName());
    }

    @NotNull
    public static MutableComponentCompat blockEntityCompat(@NotNull BlockEntity blockEntity) {
        return MutableComponentCompat.of(ComponentUtil.blockEntity(blockEntity));
    }

    @NotNull
    public static BaseComponent item(@NotNull Item item) {
        return ComponentUtil.tr(item.m_5524_(), new Object[0]);
    }

    @NotNull
    public static MutableComponentCompat itemCompat(@NotNull Item item) {
        return MutableComponentCompat.of(ComponentUtil.item(item));
    }

    public static BaseComponent color(@NotNull DyeColor color) {
        return translator.tr("color." + color.m_41065_().toLowerCase(), new Object[0]);
    }

    public static MutableComponentCompat colorCompat(@NotNull DyeColor color) {
        return MutableComponentCompat.of(ComponentUtil.color(color));
    }

    @NotNull
    public static BaseComponent hover(@NotNull BaseComponent text, HoverEvent hoverEvent) {
        text.m_130938_(style -> style.m_131144_(hoverEvent));
        return text;
    }

    @NotNull
    public static MutableComponentCompat hoverCompat(@NotNull MutableComponentCompat text, HoverEventCompat hoverEvent) {
        text.withStyleCompat(style -> style.withHoverEvent(hoverEvent));
        return text;
    }

    @NotNull
    public static BaseComponent hover(BaseComponent text, BaseComponent hoverText) {
        return ComponentUtil.hover(text, HoverEventCompat.showText((Component)hoverText));
    }

    @NotNull
    public static MutableComponentCompat hoverCompat(MutableComponentCompat text, MutableComponentCompat hoverText) {
        return ComponentUtil.hoverCompat(text, HoverEventCompat.showTextCompat(hoverText));
    }

    @NotNull
    public static BaseComponent click(@NotNull BaseComponent text, ClickEvent clickEvent) {
        text.m_130938_(style -> style.m_131142_(clickEvent));
        return text;
    }

    @NotNull
    public static MutableComponentCompat clickCompat(@NotNull MutableComponentCompat text, ClickEventCompat clickEvent) {
        text.withStyleCompat(style -> style.withClickEvent(clickEvent));
        return text;
    }

    @NotNull
    public static BaseComponent formatting(@NotNull BaseComponent text, ChatFormatting ... formattings) {
        text.m_130944_(formattings);
        return text;
    }

    @NotNull
    public static MutableComponentCompat formattingCompat(@NotNull MutableComponentCompat text, ChatFormatting ... formattings) {
        text.withStyle(formattings);
        return text;
    }

    @NotNull
    public static BaseComponent style(@NotNull BaseComponent text, Style style) {
        text.m_6270_(style);
        return text;
    }

    @NotNull
    public static MutableComponentCompat styleCompat(@NotNull MutableComponentCompat text, StyleCompat style) {
        text.setStyle(style);
        return text;
    }

    @NotNull
    public static MutableComponentCompat copy(@NotNull MutableComponentCompat text) {
        return MutableComponentCompat.of(ComponentUtil.copy(text.get()));
    }

    @NotNull
    public static BaseComponent copy(@NotNull BaseComponent text) {
        BaseComponent copied = (BaseComponent)text.m_6881_();
        if (ComponentUtil.getTextContent(copied) instanceof TranslatableComponent) {
            TranslatableComponent translatableText = (TranslatableComponent)ComponentUtil.getTextContent(copied);
            Object[] args = (Object[])translatableText.m_131329_().clone();
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof BaseComponent)) continue;
                args[i] = ComponentUtil.copy((BaseComponent)args[i]);
            }
            ((TranslatableComponentAccessor)translatableText).magiclib$setArgs(args);
        }
        return copied;
    }
}

