/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.malilib.config.option;

import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiBase;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.impl.malilib.config.ConfigContainer;
import top.hendrixshen.magiclib.impl.malilib.config.GlobalConfigManager;

public interface MagicIConfigBase
extends IConfigBase {
    public String getTranslationPrefix();

    public void onValueChanged(boolean var1);

    default public String getComment() {
        return I18n.translateOrFallback(String.format("%s.config.option.%s.comment", this.getTranslationPrefix(), this.getName()), null);
    }

    default public String getPrettyName() {
        return I18n.translateOrFallback(String.format("%s.config.option.%s.pretty_name", this.getTranslationPrefix(), this.getName()), this.getConfigGuiDisplayName());
    }

    default public String getConfigGuiDisplayName() {
        return I18n.translateOrFallback(String.format("%s.config.option.%s.name", this.getTranslationPrefix(), this.getName()), this.getName());
    }

    default public void updateStatisticOnUse() {
        this.getMagicContainer().getStatistic().onConfigUsed();
    }

    default public void setCommentModifier(@Nullable Function<String, String> commentModifier) {
        this.getMagicContainer().setCommentModifier(commentModifier);
    }

    default public String getCommentNoFooter() {
        ConfigContainer option = this.getMagicContainer();
        option.setAppendFooterFlag(false);
        try {
            String string = this.getComment();
            return string;
        }
        finally {
            option.setAppendFooterFlag(true);
        }
    }

    default public ConfigContainer getMagicContainer() {
        return GlobalConfigManager.getInstance().getContainerByConfig(this).orElseThrow(() -> new RuntimeException("Failed to fetch ConfigContainer"));
    }

    default public Function<String, String> getGuiDisplayLineModifier() {
        ConfigContainer magicContainer = this.getMagicContainer();
        if (!magicContainer.isSatisfied()) {
            return line -> GuiBase.TXT_DARK_RED + line + GuiBase.TXT_RST;
        }
        if (magicContainer.isDebugOnly()) {
            return line -> GuiBase.TXT_BLUE + line + GuiBase.TXT_RST;
        }
        if (magicContainer.isDevOnly()) {
            return line -> GuiBase.TXT_LIGHT_PURPLE + line + GuiBase.TXT_RST;
        }
        return line -> line;
    }
}

