/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.compat.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import top.hendrixshen.magiclib.api.compat.AbstractCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.world.level.block.BlockEntityCompat;

public class BlockEntityCompatImpl
extends AbstractCompat<BlockEntity>
implements BlockEntityCompat {
    private static final Logger LOGGER = LogUtils.getLogger();

    public BlockEntityCompatImpl(@NotNull BlockEntity type) {
        super(type);
    }

    @Override
    public void load(@NotNull CompoundTag compoundTag, HolderLookup.Provider provider) {
        BlockEntity self = (BlockEntity)this.get();
        try (ProblemReporter.ScopedCollector collector = new ProblemReporter.ScopedCollector(self.problemPath(), LOGGER);){
            RegistryAccess access = self.getLevel().registryAccess();
            ValueInput input = TagValueInput.create((ProblemReporter)collector, (HolderLookup.Provider)access, (CompoundTag)compoundTag);
            self.loadWithComponents(input);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load block entity from CompoundTag", (Throwable)e);
        }
    }
}

