/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.i18n.minecraft.translation;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.api.fake.i18n.ServerPlayerLanguage;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.impl.i18n.minecraft.translation.HookTranslationManager;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.StyleAccessor;
import top.hendrixshen.magiclib.util.CommonUtil;
import top.hendrixshen.magiclib.util.minecraft.ComponentUtil;

public class MagicTranslation {
    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text) {
        return MagicTranslation.translate(text, I18n.getCurrentLanguageCode());
    }

    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text, String lang) {
        return MagicTranslation.translateComponent(text, lang);
    }

    @NotNull
    public static MutableComponentCompat translate(MutableComponentCompat text, ServerPlayer player) {
        return MagicTranslation.translate(text, ((ServerPlayerLanguage)player).magicLib$getLanguage());
    }

    @NotNull
    private static MutableComponentCompat translateComponent(@NotNull MutableComponentCompat text, @NotNull String lang) {
        return MutableComponentCompat.of(MagicTranslation.translateComponent(text.get(), lang));
    }

    private static MutableComponent translateComponent(MutableComponent text, @NotNull String lang) {
        boolean[] translationRequired = new boolean[]{false};
        MagicTranslation.forEachTranslationComponent(text, lang, (txt, msgKeyString) -> {
            translationRequired[0] = true;
            return txt;
        });
        if (!translationRequired[0]) {
            return text;
        }
        return MagicTranslation.forEachTranslationComponent(ComponentUtil.copy(text), lang, (txt, msgKeyString) -> {
            MutableComponent newText;
            TranslatableContents content = (TranslatableContents)txt.m_214077_();
            String txtKey = content.m_237508_();
            Object[] txtArgs = content.m_237523_();
            if (msgKeyString == null) {
                MagicLib.getLogger().warn("MagicTranslation: Unknown translation key {}", (Object)txtKey);
                return txt;
            }
            try {
                newText = ComponentUtil.format(msgKeyString, txtArgs);
            }
            catch (IllegalArgumentException e) {
                newText = ComponentUtil.simple(msgKeyString);
            }
            newText.m_7360_().addAll(txt.m_7360_());
            newText.m_6270_(txt.m_7383_());
            return newText;
        });
    }

    @NotNull
    private static MutableComponent forEachTranslationComponent(MutableComponent text, @NotNull String lang, ComponentModifier modifier) {
        MutableComponent newHoverText;
        MutableComponent oldHoverText;
        HoverEvent hoverEvent;
        MutableComponent newText;
        int i;
        if (ComponentUtil.getTextContent(text) instanceof TranslatableContents) {
            TranslatableContents translatableText = (TranslatableContents)ComponentUtil.getTextContent(text);
            Object[] args = translatableText.m_237523_();
            for (i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof MutableComponent) || (newText = MagicTranslation.forEachTranslationComponent((MutableComponent)arg, lang, modifier)) == arg) continue;
                args[i] = newText;
            }
            if (HookTranslationManager.getInstance().isNamespaceRegistered(translatableText.m_237508_())) {
                String msgKeyString = I18n.trByCode(lang, translatableText.m_237508_());
                text = modifier.apply(text, msgKeyString);
            }
        }
        if ((hoverEvent = ((StyleAccessor)text.m_7383_()).getHoverEvent()) != null && (oldHoverText = CommonUtil.make(() -> {
            Object hoverEventText = hoverEvent.m_130823_(hoverEvent.m_130820_());
            if (hoverEvent.m_130820_() == HoverEvent.Action.f_130831_ && hoverEventText instanceof MutableComponent) {
                return (MutableComponent)hoverEventText;
            }
            return null;
        })) != null && (newHoverText = MagicTranslation.forEachTranslationComponent(oldHoverText, lang, modifier)) != oldHoverText) {
            ComponentUtil.hover(text, newHoverText);
        }
        List siblings = text.m_7360_();
        for (i = 0; i < siblings.size(); ++i) {
            Component sibling = (Component)siblings.get(i);
            newText = MagicTranslation.forEachTranslationComponent((MutableComponent)sibling, lang, modifier);
            if (newText == sibling) continue;
            siblings.set(i, newText);
        }
        return text;
    }

    @FunctionalInterface
    private static interface ComponentModifier {
        public MutableComponent apply(MutableComponent var1, @Nullable String var2);
    }
}

