/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.mixin.minecraft.network.hook;

import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.hendrixshen.magiclib.api.network.packet.ClientboundPacketHandler;
import top.hendrixshen.magiclib.api.network.packet.PacketType;
import top.hendrixshen.magiclib.impl.network.packet.MagicCustomPayload;
import top.hendrixshen.magiclib.impl.network.packet.MagicPacketRegistry;
import top.hendrixshen.magiclib.impl.network.packet.PacketHandlerContextImpl;
import top.hendrixshen.magiclib.impl.network.packet.RegistryEntry;

@Mixin(value={ClientCommonPacketListenerImpl.class})
public abstract class ClientPacketListenerMixin {
    @Inject(method={"handleCustomPayload(Lnet/minecraft/network/protocol/common/ClientboundCustomPayloadPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleClientboundCustomPayload(ClientboundCustomPayloadPacket packet, CallbackInfo ci) {
        ResourceLocation identifier = packet.payload().id();
        PacketType packetId = PacketType.of(identifier);
        RegistryEntry entry = MagicPacketRegistry.CLIENTBOUND_GAME.getEntry(packetId);
        if (entry == null) {
            return;
        }
        Object object = packet.payload();
        if (object instanceof MagicCustomPayload) {
            MagicCustomPayload mcp = (MagicCustomPayload)object;
            object = this;
            if (object instanceof ClientPacketListener) {
                ClientPacketListener self = (ClientPacketListener)object;
                ClientPacketListenerMixin.magiclib$handleCustomPayload(mcp, entry.getHandler(), self);
                ci.cancel();
            }
        }
    }

    @Unique
    private static <P> void magiclib$handleCustomPayload(MagicCustomPayload<P> payload, ClientboundPacketHandler<P> handler, ClientPacketListener self) {
        handler.handle(payload.getPacket(), new PacketHandlerContextImpl.Clientbound(self));
    }
}

