/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.platform;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.MagicLibProperties;
import top.hendrixshen.magiclib.api.platform.DistType;
import top.hendrixshen.magiclib.api.platform.Platform;
import top.hendrixshen.magiclib.api.platform.PlatformType;
import top.hendrixshen.magiclib.api.platform.adapter.ModContainerAdapter;
import top.hendrixshen.magiclib.impl.platform.adapter.ForgeLoadingModList;
import top.hendrixshen.magiclib.impl.platform.adapter.ForgeModContainer;
import top.hendrixshen.magiclib.impl.platform.adapter.ForgeModList;
import top.hendrixshen.magiclib.util.CommonUtil;
import top.hendrixshen.magiclib.util.ReflectionUtil;
import top.hendrixshen.magiclib.util.VersionUtil;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public final class ForgePlatformImpl
implements Platform {
    private static final AtomicReference<Object> instance = new AtomicReference();
    public static final ImmutableBiMap<DistType, Dist> distTypeMappings = ImmutableBiMap.of((Object)((Object)DistType.CLIENT), (Object)Dist.CLIENT, (Object)((Object)DistType.SERVER), (Object)Dist.DEDICATED_SERVER);
    private static final ValueContainer<Method> remapNameMethod = CommonUtil.make(() -> {
        ValueContainer<Class<?>> helperClazz = ReflectionUtil.getClass("net.minecraftforge.fml.util.ObfuscationReflectionHelper").or(() -> ReflectionUtil.getClass("net.minecraftforge.fml.common.ObfuscationReflectionHelper"));
        if (helperClazz.isException()) {
            return ValueContainer.exception(new RuntimeException("Unable to initialize remapping tool.", helperClazz.getException()));
        }
        return ReflectionUtil.getDeclaredMethod(helperClazz, "remapName", INameMappingService.Domain.class, String.class);
    });
    private static final BiFunction<INameMappingService.Domain, String, String> remapNameFunction = (domain, srgName) -> {
        if (remapNameMethod.isEmpty()) {
            return srgName;
        }
        ValueContainer<String> ret = ReflectionUtil.invokeStatic(remapNameMethod, domain, srgName);
        return ret.orElse((String)srgName);
    };
    private final Map<String, ModContainerAdapter> modMap = Maps.newConcurrentMap();

    @Override
    public Path getGameFolder() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Path getModsFolder() {
        return FMLPaths.MODSDIR.get();
    }

    @Override
    public PlatformType getPlatformType() {
        return PlatformType.FORGE;
    }

    @Override
    public DistType getCurrentDistType() {
        return this.getDistType(this.getCurrentEnvType());
    }

    @Override
    public boolean matchesDist(DistType distType) {
        return this.getCurrentDistType().matches(distType);
    }

    @Override
    public boolean isModLoaded(String modIdentifier) {
        return ModList.get().isLoaded(modIdentifier);
    }

    @Override
    public boolean isModExist(String modIdentifier) {
        return ForgeLoadingModList.getInstance().getModFileById(modIdentifier).isPresent();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public String getModName(String modIdentifier) {
        return ForgeModList.getInstance().getModFileById(modIdentifier).or(() -> ForgeLoadingModList.getInstance().getModFileById(modIdentifier)).orElseThrow(() -> new IllegalStateException("Access ModList too early!")).getMods().stream().filter(modInfo -> modInfo.getModId().equals(modIdentifier)).findFirst().map(IModInfo::getDisplayName).orElse("?");
    }

    @Override
    public String getModVersion(String modIdentifier) {
        return ForgeModList.getInstance().getModFileById(modIdentifier).or(() -> ForgeLoadingModList.getInstance().getModFileById(modIdentifier)).orElseThrow(() -> new IllegalStateException("Access ModList too early!")).getMods().stream().filter(modInfo -> modInfo.getModId().equals(modIdentifier)).findFirst().map(iModInfo -> iModInfo.getVersion().toString()).orElse("?");
    }

    @Override
    public ValueContainer<ModContainerAdapter> getMod(String modIdentifier) {
        return ValueContainer.ofNullable(this.modMap.get(modIdentifier)).or(() -> {
            try {
                ModContainerAdapter mod = ForgeModContainer.of(modIdentifier);
                this.modMap.put(modIdentifier, mod);
                return ValueContainer.of(mod);
            }
            catch (Exception e) {
                return ValueContainer.empty();
            }
        });
    }

    @Override
    public Collection<ModContainerAdapter> getMods() {
        for (IModInfo info : ModList.get().getMods()) {
            this.getMod(info.getModId());
        }
        return this.modMap.values();
    }

    @Override
    public Collection<String> getModIds() {
        return ForgeModList.getInstance().getMods().or(() -> ForgeLoadingModList.getInstance().getMods()).orElseThrow(() -> new IllegalStateException("Access ModList too early!")).stream().map(IModInfo::getModId).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public String getNamedMappingName() {
        String methodName;
        String name = MagicLibProperties.DEV_MAPPING_NAME.getStringValue();
        if (name != null) {
            return name;
        }
        String mcVer = MagicLib.getInstance().getCurrentPlatform().getModVersion("minecraft");
        if (VersionUtil.isVersionSatisfyPredicate(mcVer, ">1.20.5-")) {
            return this.isDevelopmentEnvironment() ? "mojang" : null;
        }
        String intermediaryMethodName = VersionUtil.isVersionSatisfyPredicate(mcVer, ">1.17-") ? "m_91341_" : "func_230150_b_";
        switch (methodName = remapNameFunction.apply(INameMappingService.Domain.METHOD, intermediaryMethodName)) {
            case "updateTitle": {
                return "mojang";
            }
            case "updateWindowTitle": {
                return "yarn";
            }
            case "setDefaultMinecraftTitle": {
                return "mcp";
            }
            case "m_91341_": 
            case "func_230150_b_": {
                return null;
            }
        }
        return "unknown";
    }

    public Dist getCurrentEnvType() {
        return FMLLoader.getDist();
    }

    public DistType getDistType(Dist envType) {
        return (DistType)((Object)distTypeMappings.inverse().get((Object)envType));
    }

    public Dist getDist(DistType sideType) {
        return (Dist)distTypeMappings.get((Object)sideType);
    }

    @Generated
    private ForgePlatformImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Platform getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ForgePlatformImpl actualValue = new ForgePlatformImpl();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (Platform)($value == instance ? null : $value);
    }
}

