/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.minecraft;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class NetworkUtil {
    private static final int TAG_ID_COMPOUND = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NbtStyle guessNbtStyle(@NotNull FriendlyByteBuf buf) {
        int n = buf.readableBytes();
        int prevReaderIndex = buf.readerIndex();
        try {
            if (n < 2) {
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            byte typeId = buf.readByte();
            if (typeId != 10) {
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            if (n == 2) {
                if (buf.readByte() == 0) {
                    NbtStyle nbtStyle = NbtStyle.MODERN;
                    return nbtStyle;
                }
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            byte[] bytes = new byte[2];
            buf.readBytes(bytes);
            if (bytes[0] == 0 && bytes[1] == 0) {
                NbtStyle nbtStyle = NbtStyle.LEGACY;
                return nbtStyle;
            }
            if (0 <= bytes[0] && bytes[0] < 13) {
                NbtStyle nbtStyle = NbtStyle.MODERN;
                return nbtStyle;
            }
        }
        finally {
            buf.readerIndex(prevReaderIndex);
        }
        return NbtStyle.UNKNOWN;
    }

    public static CompoundTag readNbt(FriendlyByteBuf buf) {
        NbtStyle nbtStyle = NetworkUtil.guessNbtStyle(buf);
        if (NbtStyle.CURRENT == NbtStyle.LEGACY && nbtStyle == NbtStyle.MODERN) {
            int prevReaderIndex = buf.readerIndex();
            FriendlyByteBuf tweakedBuf = new FriendlyByteBuf(Unpooled.buffer());
            tweakedBuf.writeByte((int)buf.readByte());
            tweakedBuf.writeByte(0).writeByte(0);
            tweakedBuf.writeBytes((ByteBuf)buf);
            buf.readerIndex(prevReaderIndex);
            CompoundTag nbt = tweakedBuf.m_130260_();
            int n = tweakedBuf.readerIndex();
            buf.readBytes(Math.max(0, n - 2));
            return nbt;
        }
        if (NbtStyle.CURRENT == NbtStyle.MODERN && nbtStyle == NbtStyle.LEGACY) {
            int prevReaderIndex = buf.readerIndex();
            FriendlyByteBuf tweakedBuf = new FriendlyByteBuf(Unpooled.buffer());
            tweakedBuf.writeByte((int)buf.readByte());
            buf.readBytes(2);
            tweakedBuf.writeBytes((ByteBuf)buf);
            buf.readerIndex(prevReaderIndex);
            CompoundTag nbt = tweakedBuf.m_130260_();
            int n = tweakedBuf.readerIndex();
            buf.readBytes(Math.max(0, n > 1 ? n + 2 : n));
            return nbt;
        }
        return buf.m_130260_();
    }

    public static enum NbtStyle {
        UNKNOWN,
        LEGACY,
        MODERN;

        public static final NbtStyle CURRENT;

        static {
            CURRENT = LEGACY;
        }
    }
}

