/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.compat.minecraft.client.gui;

import com.google.common.collect.ImmutableBiMap;
import lombok.Generated;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import top.hendrixshen.magiclib.impl.compat.minecraft.client.gui.FontCompatImpl;
import top.hendrixshen.magiclib.util.collect.Provider;

@OnlyIn(value=Dist.CLIENT)
public interface FontCompat
extends Provider<Font> {
    public static final ImmutableBiMap<DisplayMode, Font.DisplayMode> displayModeMappings = ImmutableBiMap.of((Object)((Object)DisplayMode.NORMAL), (Object)Font.DisplayMode.NORMAL, (Object)((Object)DisplayMode.SEE_THROUGH), (Object)Font.DisplayMode.SEE_THROUGH, (Object)((Object)DisplayMode.POLYGON_OFFSET), (Object)Font.DisplayMode.POLYGON_OFFSET);

    @NotNull
    public static FontCompat of(@NotNull Font font) {
        return new FontCompatImpl(font);
    }

    public static DisplayMode getCompatMode(Font.DisplayMode displayMode) {
        return (DisplayMode)((Object)displayModeMappings.inverse().get((Object)displayMode));
    }

    public static Font.DisplayMode getDisplayMode(DisplayMode displayModeCompat) {
        return (Font.DisplayMode)displayModeMappings.get((Object)displayModeCompat);
    }

    public int drawInBatch(String var1, float var2, float var3, int var4, boolean var5, Matrix4f var6, MultiBufferSource var7, DisplayMode var8, int var9, int var10);

    public int drawInBatch(String var1, float var2, float var3, int var4, boolean var5, Matrix4f var6, MultiBufferSource var7, @NotNull DisplayMode var8, int var9, int var10, boolean var11);

    public int drawInBatch(@NotNull Component var1, float var2, float var3, int var4, boolean var5, Matrix4f var6, MultiBufferSource var7, DisplayMode var8, int var9, int var10);

    public int drawInBatch(FormattedCharSequence var1, float var2, float var3, int var4, boolean var5, Matrix4f var6, MultiBufferSource var7, @NotNull DisplayMode var8, int var9, int var10);

    public int width(@NotNull Component var1);

    @OnlyIn(value=Dist.CLIENT)
    public static enum DisplayMode {
        NORMAL(false),
        SEE_THROUGH(true),
        POLYGON_OFFSET(true);

        private final boolean seeThrough;

        private DisplayMode(boolean seeThrough) {
            this.seeThrough = seeThrough;
        }

        @Generated
        public boolean isSeeThrough() {
            return this.seeThrough;
        }
    }
}

