/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.migration;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.Map;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigHandler;
import top.hendrixshen.magiclib.api.malilib.config.migration.ConfigMigrator;
import top.hendrixshen.magiclib.util.collect.SimplePredicate;

public class RenameConfigMigrator
implements ConfigMigrator {
    private final Map<String, String> migrateMapping = Maps.newLinkedHashMap();
    private final SimplePredicate<MagicConfigHandler> migratePredicate;

    public RenameConfigMigrator(Map<String, String> migrateMapping, SimplePredicate<MagicConfigHandler> migratePredicate) {
        this.migrateMapping.putAll(migrateMapping);
        this.migratePredicate = migratePredicate;
    }

    public void addMigrateMapping(String oldName, String newName) {
        this.migrateMapping.put(oldName, newName);
    }

    public void addMigrateMapping(Map<String, String> renameMapping) {
        this.migrateMapping.putAll(renameMapping);
    }

    @Override
    public boolean migrate(MagicConfigHandler configHandler) {
        JsonObject loadedJson = configHandler.getLoadedJson();
        boolean ret = false;
        for (String category : configHandler.getConfigManager().getCategories()) {
            JsonObject obj = JsonUtils.getNestedObject((JsonObject)loadedJson, (String)category, (boolean)false);
            if (obj == null) continue;
            for (Map.Entry<String, String> entry : this.migrateMapping.entrySet()) {
                String oldName = entry.getKey();
                String newName = entry.getValue();
                if (!obj.has(oldName)) {
                    MagicLib.getLogger().warn("[RenameConfigMigrator-{}]Skipped renaming config, because source config does not exist(source={}.{}, destination={}.{}).", (Object)configHandler.getIdentifier(), (Object)category, (Object)oldName, (Object)category, (Object)newName);
                    continue;
                }
                if (obj.has(newName)) {
                    MagicLib.getLogger().warn("[RenameConfigMigrator-{}]Skipped renaming config, because destination config already exists(source={}.{}, destination={}.{}).", (Object)configHandler.getIdentifier(), (Object)category, (Object)oldName, (Object)category, (Object)newName);
                    continue;
                }
                obj.add(newName, obj.get(oldName));
                ret = true;
                MagicLib.getLogger().info("[RenameConfigMigrator-{}]Renamed config: {}.{} -> {}.{}", (Object)configHandler.getIdentifier(), (Object)category, (Object)oldName, (Object)category, (Object)newName);
            }
        }
        return ret;
    }

    @Override
    public boolean shouldMigrate(MagicConfigHandler configHandler) {
        return this.migratePredicate.test(configHandler);
    }
}

