/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.mixin.audit;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.MixinEnvironment;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.MagicLibProperties;

public class MixinAuditor {
    public static final int DEFAULT_FAIL_CODE = -1296387927;
    public static final AtomicBoolean triggered = new AtomicBoolean(false);

    public static boolean isEnable() {
        return MagicLibProperties.MIXIN_AUDITOR_ENABLE.getBooleanValue();
    }

    public static void trigger(@NotNull String trigger) {
        if (trigger.equalsIgnoreCase(MagicLibProperties.MIXIN_AUDITOR_TRIGGER.getStringValue()) && triggered.compareAndSet(false, true)) {
            MixinAuditor.runMixinAudit();
        }
    }

    public static int getFailCode() {
        try {
            return Integer.parseInt(MagicLibProperties.MIXIN_AUDITOR_FAIL_CODE.getStringValue());
        }
        catch (NumberFormatException e) {
            return -1296387927;
        }
    }

    public static void runMixinAudit() {
        boolean exit;
        if (!MixinAuditor.isEnable()) {
            return;
        }
        MagicLib.getLogger().info("Triggered mixin audit.");
        boolean status = MixinAuditor.runMixinAuditImpl();
        switch (ExitMode.get().ordinal()) {
            case 0: {
                exit = true;
                break;
            }
            case 1: {
                exit = !status;
                break;
            }
            case 2: {
                exit = false;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (exit) {
            Runtime.getRuntime().halt(status ? 0 : MixinAuditor.getFailCode());
        }
    }

    public static boolean runMixinAuditImpl() {
        try {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        catch (Throwable t) {
            MagicLib.getLogger().error("Exception occurs while auditing mixin.", t);
            return false;
        }
        MagicLib.getLogger().info("Mixin audited successfully!");
        return true;
    }

    public static enum ExitMode {
        ALWAYS,
        FAILED,
        NEVER;

        public static final ExitMode DEFAULT;

        public static ExitMode get() {
            return MagicLibProperties.MIXIN_AUDITOR_EXIT_MODE.getEnumValue(DEFAULT);
        }

        static {
            DEFAULT = ALWAYS;
        }
    }
}

