/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.render;

import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import top.hendrixshen.magiclib.api.render.context.LevelRenderContext;
import top.hendrixshen.magiclib.api.render.context.RenderContext;

public class CameraPositionTransformer {
    private final Vec3 pos;
    private RenderContext context;

    @NotNull
    public static CameraPositionTransformer create(Vec3 pos) {
        return new CameraPositionTransformer(pos);
    }

    private CameraPositionTransformer(Vec3 pos) {
        this.pos = pos;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void apply(@NotNull RenderContext context) {
        this.context = context;
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 vec3 = this.pos.m_82546_(camera.m_90583_());
        context.pushMatrix();
        context.translate(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
        context.mulPoseMatrix(new Matrix4f().rotation((Quaternionfc)camera.m_253121_()));
    }

    public void apply(@NotNull LevelRenderContext context) {
        this.apply((RenderContext)((Object)context));
    }

    public void restore() {
        if (this.context == null) {
            throw new RuntimeException("CameraPositionTransformer: Calling restore before calling apply");
        }
        this.context.popMatrix();
        this.context = null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public RenderContext getContext() {
        return Objects.requireNonNull(this.context);
    }
}

