/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.mixin.malilib.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.JsonUtils;
import org.spongepowered.asm.mixin.Mixin;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.dependency.DependencyType;
import top.hendrixshen.magiclib.api.dependency.annotation.CompositeDependencies;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependencies;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependency;
import top.hendrixshen.magiclib.api.platform.PlatformType;
import top.hendrixshen.magiclib.impl.malilib.config.option.MagicConfigBooleanHotkeyed;

@CompositeDependencies(value={@Dependencies(require={@Dependency(value="malilib", versionPredicates={"<0.11.4"}), @Dependency(dependencyType=DependencyType.PLATFORM, platformType=PlatformType.FABRIC_LIKE)}), @Dependencies(require={@Dependency(value="minecraft", versionPredicates={">=1.16- <1.18-"}), @Dependency(value="malilib", versionPredicates={"*"}), @Dependency(dependencyType=DependencyType.PLATFORM, platformType=PlatformType.FORGE_LIKE)}), @Dependencies(require={@Dependency(value="minecraft", versionPredicates={"1.16.x"}), @Dependency(value="mafglib", versionPredicates={"*"}), @Dependency(dependencyType=DependencyType.PLATFORM, platformType=PlatformType.FORGE_LIKE)}), @Dependencies(require={@Dependency(value="minecraft", versionPredicates={"1.18.x"}), @Dependency(value="malilib", versionPredicates={"*"}), @Dependency(dependencyType=DependencyType.PLATFORM, platformType=PlatformType.FORGE_LIKE)})})
@Mixin(value={MagicConfigBooleanHotkeyed.class}, remap=false)
public abstract class MagicConfigBooleanHotkeyedMixin
extends ConfigBoolean
implements IHotkeyTogglable {
    public MagicConfigBooleanHotkeyedMixin(String name, boolean defaultValue, String comment) {
        super(name, defaultValue, comment);
    }

    public boolean isModified() {
        return super.isModified() || this.getKeybind().isModified();
    }

    public void resetToDefault() {
        super.resetToDefault();
        this.getKeybind().resetToDefault();
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (JsonUtils.hasBoolean((JsonObject)obj, (String)"enabled")) {
                    super.setValueFromJsonElement(obj.get("enabled"));
                }
                if (JsonUtils.hasObject((JsonObject)obj, (String)"hotkey")) {
                    JsonObject hotkeyObj = obj.getAsJsonObject("hotkey");
                    if (JsonUtils.hasString((JsonObject)hotkeyObj, (String)"keys")) {
                        this.getKeybind().setValueFromString(hotkeyObj.get("keys").getAsString());
                    }
                    if (JsonUtils.hasObject((JsonObject)hotkeyObj, (String)"settings")) {
                        this.getKeybind().setSettings(KeybindSettings.fromJson((JsonObject)hotkeyObj.getAsJsonObject("settings")));
                    }
                }
            } else {
                super.setValueFromJsonElement(element);
            }
        }
        catch (Exception e) {
            MagicLib.getLogger().warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    public JsonElement getAsJsonElement() {
        JsonObject obj = new JsonObject();
        obj.add("enabled", super.getAsJsonElement());
        JsonObject keyBindObj = new JsonObject();
        keyBindObj.add("keys", (JsonElement)new JsonPrimitive(this.getKeybind().getStringValue()));
        if (this.getKeybind().areSettingsModified()) {
            keyBindObj.add("settings", (JsonElement)this.getKeybind().getSettings().toJson());
        }
        obj.add("hotkey", (JsonElement)keyBindObj);
        return obj;
    }
}

