/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.mixin.minecraft.network.hook;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.hendrixshen.magiclib.api.network.packet.PacketCodec;
import top.hendrixshen.magiclib.api.network.packet.PacketType;
import top.hendrixshen.magiclib.api.network.packet.ServerboundPacketHandler;
import top.hendrixshen.magiclib.impl.network.packet.MagicCustomPayload;
import top.hendrixshen.magiclib.impl.network.packet.MagicPacketRegistry;
import top.hendrixshen.magiclib.impl.network.packet.PacketHandlerContextImpl;
import top.hendrixshen.magiclib.impl.network.packet.RegistryEntry;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.ServerboundCustomPayloadPacketAccessor;
import top.hendrixshen.magiclib.util.MiscUtil;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin {
    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleServerboundCustomPayload(ServerboundCustomPayloadPacket packet, CallbackInfo ci) {
        ResourceLocation identifier = ((ServerboundCustomPayloadPacketAccessor)packet).magiclib$getIdentifier();
        PacketType type = PacketType.of(identifier);
        RegistryEntry entry = MagicPacketRegistry.SERVERBOUND_GAME.getEntry(type);
        if (entry == null) {
            return;
        }
        FriendlyByteBuf buf = ((ServerboundCustomPayloadPacketAccessor)packet).magiclib$getData();
        MagicCustomPayload<FriendlyByteBuf> payload = new MagicCustomPayload<FriendlyByteBuf>((PacketType<FriendlyByteBuf>)type, (PacketCodec<FriendlyByteBuf>)entry.getCodec(), buf);
        ServerGamePacketListenerImplMixin.magiclib$handleCustomPayload(payload, entry.getHandler(), (ServerGamePacketListenerImpl)MiscUtil.cast(this));
        ci.cancel();
    }

    @Unique
    private static <P> void magiclib$handleCustomPayload(MagicCustomPayload<P> payload, ServerboundPacketHandler<P> handler, ServerGamePacketListenerImpl self) {
        handler.handle(payload.getPacket(), new PacketHandlerContextImpl.Serverbound(self));
    }
}

