/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.fabric;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class LoaderUtil {
    public static Path normalizePath(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return LoaderUtil.normalizeExistingPath(path);
        }
        return path.toAbsolutePath().normalize();
    }

    @NotNull
    public static Path normalizeExistingPath(@NotNull Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean hasMacOs() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
    }
}

