/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.event.minecraft.render;

import java.util.List;
import lombok.Generated;
import net.minecraft.client.multiplayer.ClientLevel;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fStack;
import top.hendrixshen.magiclib.api.compat.minecraft.util.ProfilerCompat;
import top.hendrixshen.magiclib.api.event.Event;
import top.hendrixshen.magiclib.api.event.minecraft.render.RenderLevelListener;
import top.hendrixshen.magiclib.api.render.context.LevelRenderContext;
import top.hendrixshen.magiclib.api.render.context.RenderContext;

public class RenderLevelEvent {

    public static class PostRender
    implements Event<RenderLevelListener> {
        private final Info info;

        public PostRender(Info info) {
            this.info = info;
        }

        @Override
        public void dispatch(@NotNull List<RenderLevelListener> listeners) {
            ProfilerCompat.get().push("Magiclib#PostLevelRenderHook");
            for (RenderLevelListener listener : listeners) {
                listener.postRenderLevel(this.info.level, this.info.renderContext);
            }
            ProfilerCompat.get().pop();
        }

        @Override
        public Class<RenderLevelListener> getListenerType() {
            return RenderLevelListener.class;
        }
    }

    public static class PreRender
    implements Event<RenderLevelListener> {
        private final Info info;

        public PreRender(Info info) {
            this.info = info;
        }

        @Override
        public void dispatch(@NotNull List<RenderLevelListener> listeners) {
            ProfilerCompat.get().push("Magiclib#PreLevelRenderHook");
            for (RenderLevelListener listener : listeners) {
                listener.preRenderLevel(this.info.level, this.info.renderContext);
            }
            ProfilerCompat.get().pop();
        }

        @Override
        public Class<RenderLevelListener> getListenerType() {
            return RenderLevelListener.class;
        }
    }

    public static class Info {
        @NotNull
        private final ClientLevel level;
        @NotNull
        private final LevelRenderContext renderContext;

        public static Info of(@NotNull ClientLevel level, @NotNull Matrix4fStack matrixStack) {
            return new Info(level, RenderContext.level(matrixStack));
        }

        @Generated
        private Info(@NotNull ClientLevel level, @NotNull LevelRenderContext renderContext) {
            if (level == null) {
                throw new NullPointerException("level is marked non-null but is null");
            }
            if (renderContext == null) {
                throw new NullPointerException("renderContext is marked non-null but is null");
            }
            this.level = level;
            this.renderContext = renderContext;
        }
    }
}

