/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.gui;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.IConfigResettable;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetHoverInfo;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.gui.widgets.WidgetSearchBar;
import fi.dy.masa.malilib.interfaces.IStringValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigManager;
import top.hendrixshen.magiclib.impl.malilib.SharedConstants;
import top.hendrixshen.magiclib.impl.malilib.config.ConfigContainer;
import top.hendrixshen.magiclib.impl.malilib.config.gui.SelectorDropDownList;
import top.hendrixshen.magiclib.mixin.malilib.accessor.WidgetSearchBarAccessor;
import top.hendrixshen.magiclib.util.minecraft.render.RenderUtil;
import top.hendrixshen.magiclib.util.serializable.JsonSaveAble;

public class MagicConfigGui
extends GuiConfigsBase {
    private final String identifier;
    private final MagicConfigManager configManager;
    private final Supplier<String> titleProvider;
    private final List<WidgetBase> hoveringWidgets = Lists.newArrayList();
    private WidgetSearchBar searchBar = null;

    public MagicConfigGui(String identifier, MagicConfigManager configManager, String title) {
        this(identifier, configManager, () -> title);
    }

    public MagicConfigGui(String identifier, MagicConfigManager configManager, @NotNull Supplier<String> titleProvider) {
        super(10, 50, identifier, null, titleProvider.get(), new Object[0]);
        this.identifier = identifier;
        this.configManager = configManager;
        this.titleProvider = titleProvider;
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        this.hoveringWidgets.clear();
        this.setTitle(this.titleProvider.get());
        int x = 10;
        int y = 26;
        for (String category : this.configManager.getCategories()) {
            if (this.configManager.getContainers(category).stream().filter(this::filterUnsatisfiedConfig).noneMatch(this::isValidConfig)) continue;
            x += this.createNavigationButton(x, y, category);
        }
        x = this.width - 11;
        x = this.initSortingStrategyDropDownList(x) - 5;
        if (this.searchBar != null) {
            GuiTextFieldGeneric searchBox = ((WidgetSearchBarAccessor)this.searchBar).magiclib$getSearchBox();
            int deltaWidth = Math.max(50, x - this.searchBar.getX()) - this.searchBar.getWidth();
            this.searchBar.setWidth(this.searchBar.getWidth() + deltaWidth);
            searchBox.setWidth(searchBox.getWidth() + deltaWidth);
        }
        this.initBottomLine();
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        Comparator<ConfigContainer> nameComparator = Comparator.comparing(c -> c.getConfig().getName(), String::compareToIgnoreCase);
        List configs = this.getCurrentContainers().stream().filter(this::filterUnsatisfiedConfig).filter(this::isValidConfig).sorted(this.configManager.getGuiSetting().getSortingStrategy().getComparator().thenComparing(nameComparator)).map(ConfigContainer::getConfig).collect(Collectors.toList());
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public boolean hideUnAvailableConfigs() {
        return false;
    }

    public boolean isDebug() {
        return false;
    }

    public boolean isDevOnly() {
        return this.isDebug() && MagicLib.getInstance().getCurrentPlatform().isDevelopmentEnvironment();
    }

    private boolean isValidConfig(@NotNull ConfigContainer configContainer) {
        if (configContainer.isDebugOnly() && !this.isDebug()) {
            return false;
        }
        return !configContainer.isDevOnly() || this.isDevOnly();
    }

    private boolean filterUnsatisfiedConfig(ConfigContainer configContainer) {
        return !this.hideUnAvailableConfigs() || configContainer.isSatisfied();
    }

    private Collection<ConfigContainer> getCurrentContainers() {
        return this.configManager.getContainers(this.configManager.getGuiSetting().category);
    }

    private <T extends IStringValue> int initDropDownList(int x, @NotNull List<T> entries, T defaultValue, Supplier<T> valueGetter, Consumer<T> valueSetter, String hoverTextKey, @NotNull Consumer<SelectorDropDownList<T>> postProcessor) {
        int y = this.getListY() + 3;
        int height = 16;
        int maxTextWidth = entries.stream().filter(Objects::nonNull).mapToInt(e -> this.getStringWidth(e.getStringValue())).max().orElse(-1);
        int width = Math.max(maxTextWidth, 40) + 20;
        SelectorDropDownList<T> dd = new SelectorDropDownList<T>(x - width, y, width, height, 200, entries.size(), entries);
        dd.setEntryChangeListener(entry -> this.setDisplayParameter((IStringValue)valueGetter.get(), entry, () -> valueSetter.accept(entry), true));
        dd.setSelectedEntry(defaultValue);
        dd.setHoverText(hoverTextKey, new Object[0]);
        postProcessor.accept(dd);
        this.addWidget((WidgetBase)dd);
        this.hoveringWidgets.add((WidgetBase)dd);
        return dd.getX();
    }

    private int createNavigationButton(int x, int y, String category) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, I18n.tr(String.format("%s.config.category.%s.name", this.identifier, category)), new String[0]);
        button.setEnabled(!this.configManager.getGuiSetting().category.equals(category));
        String translatedHoverText = I18n.translateOrFallback(String.format("%s.config.category.%s.desc", this.identifier, category), null);
        if (translatedHoverText != null) {
            button.setHoverStrings(new String[]{translatedHoverText});
        }
        this.addButton((ButtonBase)button, (b, mb) -> this.setDisplayParameter(this.configManager.getGuiSetting().category, category, () -> this.configManager.getGuiSetting().setCategory(category), false));
        return button.getWidth() + 2;
    }

    private <T> void setDisplayParameter(T currentValue, T newValue, Runnable valueSetter, boolean keepSearchBar) {
        if (newValue != currentValue) {
            valueSetter.run();
            this.reDraw(keepSearchBar);
        }
    }

    private void initBottomLine() {
        int available = 0;
        int unavailable = 0;
        int modified = 0;
        int debugOnly = 0;
        int devOnly = 0;
        for (ConfigContainer config : this.getCurrentContainers()) {
            if (config.isDebugOnly()) {
                ++debugOnly;
            }
            if (config.isDevOnly()) {
                ++devOnly;
            }
            if (this.isValidConfig(config) && config.isSatisfied()) {
                if (config.getConfig() instanceof IConfigResettable && ((IConfigResettable)config.getConfig()).isModified()) {
                    ++modified;
                }
                ++available;
                continue;
            }
            ++unavailable;
        }
        int total = available + unavailable;
        String stats = I18n.tr("magiclib.config.gui.bottom_line.stat", available, modified);
        int width = RenderUtil.getRenderWidth(stats);
        int height = RenderUtil.TEXT_HEIGHT;
        int x = 10;
        int y = this.height - height - 10;
        WidgetHoverInfo widgetHoverInfo = new WidgetHoverInfo(x, y - 2, width, height + 4, I18n.tr("magiclib.config.gui.bottom_line.stat.hover", available, unavailable, total, modified, debugOnly, devOnly, SharedConstants.getColoredEnableStateText(this.isDebug()), SharedConstants.getColoredEnableStateText(this.hideUnAvailableConfigs())), new Object[0]);
        this.addLabel(x, y, width, height, -5592406, new String[]{stats});
        this.addWidget((WidgetBase)widgetHoverInfo);
    }

    private int initSortingStrategyDropDownList(int x) {
        List<SortingStrategy> items = Arrays.asList(SortingStrategy.values());
        return this.initDropDownList(x, items, this.configManager.getGuiSetting().getSortingStrategy(), () -> this.configManager.getGuiSetting().getSortingStrategy(), strategy -> this.configManager.getGuiSetting().setSortingStrategy((SortingStrategy)((Object)strategy)), "magiclib.config.gui.sorting_strategy.label_text", dd -> {});
    }

    public void reDraw() {
        this.reDraw(true);
    }

    public void reDraw(boolean keepSearchBar) {
        String previousSearchBarText = null;
        boolean previousSearchBoxFocus = false;
        if (keepSearchBar && this.searchBar != null && this.searchBar.isSearchOpen()) {
            previousSearchBarText = this.searchBar.getFilter();
            previousSearchBoxFocus = ((WidgetSearchBarAccessor)this.searchBar).magiclib$getSearchBox().isFocused();
        }
        super.removed();
        this.reCreateListWidget();
        if (this.searchBar != null && previousSearchBarText != null) {
            this.searchBar.setSearchOpen(true);
            ((WidgetSearchBarAccessor)this.searchBar).magiclib$getSearchBox().setValue(previousSearchBarText);
            ((WidgetSearchBarAccessor)this.searchBar).magiclib$getSearchBox().setFocused(previousSearchBoxFocus);
        }
        Objects.requireNonNull((WidgetListConfigOptions)this.getListWidget()).resetScrollbarPosition();
        this.initGui();
    }

    public void renderDropDownList(GuiGraphics poseStackOrGuiGraphics, int mouseX, int mouseY) {
        this.hoveringWidgets.forEach(widget -> widget.render(poseStackOrGuiGraphics, mouseX, mouseY, widget.isMouseOver(mouseX, mouseY)));
    }

    @Generated
    public void setSearchBar(WidgetSearchBar searchBar) {
        this.searchBar = searchBar;
    }

    public static class GuiSetting
    implements JsonSaveAble {
        private String category = "all";
        private SortingStrategy sortingStrategy = SortingStrategy.ALPHABET;

        @Override
        public void dumpToJson(@NotNull JsonObject jsonObject) {
            jsonObject.addProperty("category", this.category);
            jsonObject.addProperty("sortingStrategy", this.sortingStrategy.name());
        }

        @Override
        public void loadFromJson(@NotNull JsonObject jsonObject) {
            this.category = jsonObject.get("category").getAsString();
            this.sortingStrategy = this.getEnumSafe(jsonObject, "sortingStrategy", this.sortingStrategy);
        }

        @Generated
        public String getCategory() {
            return this.category;
        }

        @Generated
        public SortingStrategy getSortingStrategy() {
            return this.sortingStrategy;
        }

        @Generated
        public void setCategory(String category) {
            this.category = category;
        }

        @Generated
        public void setSortingStrategy(SortingStrategy sortingStrategy) {
            this.sortingStrategy = sortingStrategy;
        }
    }

    public static enum SortingStrategy implements IStringValue
    {
        ALPHABET((a, b) -> 0),
        MOST_RECENTLY_USED(Collections.reverseOrder(Comparator.comparingLong(c -> c.getStatistic().lastUsedTime))),
        MOST_COMMONLY_USED(Collections.reverseOrder(Comparator.comparingLong(c -> c.getStatistic().useAmount)));

        private final Comparator<ConfigContainer> comparator;

        private SortingStrategy(Comparator<ConfigContainer> comparator) {
            this.comparator = comparator;
        }

        public String getStringValue() {
            return I18n.tr("magiclib.config.gui.sorting_strategy." + this.name().toLowerCase());
        }

        @Generated
        public Comparator<ConfigContainer> getComparator() {
            return this.comparator;
        }
    }
}

