/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.mixin.minecraft.event.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.hendrixshen.magiclib.impl.event.EventManager;
import top.hendrixshen.magiclib.impl.event.minecraft.render.RenderEntityEvent;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={EntityRenderer.class})
public abstract class EntityRendererMixin {
    @Inject(method={"render(Lnet/minecraft/world/entity/Entity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")})
    private void preRenderEntity(Entity entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource source, int light, CallbackInfo ci) {
        EventManager.dispatch(new RenderEntityEvent.PreRender(RenderEntityEvent.EntityRenderContext.of(entity, poseStack, tickDelta)));
    }

    @Inject(method={"render(Lnet/minecraft/world/entity/Entity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="RETURN")})
    private void postRenderEntity(Entity entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource source, int light, CallbackInfo ci) {
        EventManager.dispatch(new RenderEntityEvent.PostRender(RenderEntityEvent.EntityRenderContext.of(entity, poseStack, tickDelta)));
    }
}

