/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.platform.adapter;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import top.hendrixshen.magiclib.api.platform.adapter.forge.ModListAdapter;
import top.hendrixshen.magiclib.util.CommonUtil;
import top.hendrixshen.magiclib.util.ReflectionUtil;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public class ForgeModList
implements ModListAdapter {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private static final ValueContainer<Method> getModFilesMethod = CommonUtil.make(() -> {
        ValueContainer<Class<?>> modListClazz = ReflectionUtil.getClass("net.minecraftforge.fml.ModList");
        if (modListClazz.isException()) {
            return ValueContainer.exception(new RuntimeException("Unable to initialize ModList.", modListClazz.getException()));
        }
        return ReflectionUtil.getMethod(modListClazz, "getModFiles", new Class[0]);
    });
    private static final Function<ModList, List<IModFileInfo>> getModFilesFunction = modList -> {
        if (getModFilesMethod.isEmpty()) {
            return Lists.newArrayList();
        }
        ValueContainer<ArrayList> ret = ReflectionUtil.invoke(getModFilesMethod, modList, new Object[0]);
        return ret.orElse(Lists.newArrayList());
    };
    private static final ValueContainer<Method> getModsMethod = CommonUtil.make(() -> {
        ValueContainer<Class<?>> modListClazz = ReflectionUtil.getClass("net.minecraftforge.fml.ModList");
        if (modListClazz.isException()) {
            return ValueContainer.exception(new RuntimeException("Unable to initialize ModList.", modListClazz.getException()));
        }
        return ReflectionUtil.getMethod(modListClazz, "getMods", new Class[0]);
    });
    private static final Function<ModList, List<IModInfo>> getModsFunction = modList -> {
        if (getModsMethod.isEmpty()) {
            return Lists.newArrayList();
        }
        ValueContainer<ArrayList> ret = ReflectionUtil.invoke(getModsMethod, modList, new Object[0]);
        return ret.orElse(Lists.newArrayList());
    };
    private static final ValueContainer<Method> getModFileByIdMethod = CommonUtil.make(() -> {
        ValueContainer<Class<?>> modListClazz = ReflectionUtil.getClass("net.minecraftforge.fml.ModList");
        if (modListClazz.isException()) {
            return ValueContainer.exception(new RuntimeException("Unable to initialize ModList.", modListClazz.getException()));
        }
        return ReflectionUtil.getMethod(modListClazz, "getModFileById", String.class);
    });
    private static final BiFunction<ModList, String, IModFileInfo> getModFileByIdFunction = (modList, identifier) -> {
        if (getModFileByIdMethod.isEmpty()) {
            return null;
        }
        ValueContainer<Object> ret = ReflectionUtil.invoke(getModFileByIdMethod, modList, identifier);
        return ret.orElse(null);
    };

    @Override
    public ValueContainer<Collection<IModFileInfo>> getModFiles() {
        return ValueContainer.ofNullable(ModList.get()).map(getModFilesFunction);
    }

    @Override
    public ValueContainer<Collection<IModInfo>> getMods() {
        return ValueContainer.ofNullable(ModList.get()).map(getModsFunction);
    }

    @Override
    public ValueContainer<IModFileInfo> getModFileById(String identifier) {
        return ValueContainer.ofNullable(ModList.get()).map(modList -> getModFileByIdFunction.apply((ModList)modList, identifier));
    }

    @Generated
    private ForgeModList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ModListAdapter getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ForgeModList actualValue = new ForgeModList();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ModListAdapter)($value == instance ? null : $value);
    }
}

