/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.render;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.render.context.GuiRenderContext;
import top.hendrixshen.magiclib.api.render.context.LevelRenderContext;
import top.hendrixshen.magiclib.api.render.context.RenderContext;

public class Scaler {
    private final double anchorX;
    private final double anchorY;
    private final double factor;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    private RenderContext context;
    private Runnable restoreFunc;

    @NotNull
    public static Scaler create(double anchorX, double anchorY, double factor) {
        return new Scaler(anchorX, anchorY, factor);
    }

    private Scaler(double anchorX, double anchorY, double factor) {
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        if (factor <= 0.0) {
            throw new IllegalArgumentException("factor should be greater than 0, but " + factor + " found");
        }
        this.factor = factor;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void apply(RenderContext context) {
        this.context = context;
        context.pushMatrix();
        context.translate(-this.anchorX * this.factor, -this.anchorY * this.factor, 0.0);
        context.scale(this.factor, this.factor, 1.0);
        context.translate(this.anchorX / this.factor, this.anchorY / this.factor, 0.0);
        this.restoreFunc = context::popMatrix;
    }

    public void apply(LevelRenderContext context) {
        context.pushMatrix();
        context.translate(-this.anchorX * this.factor, -this.anchorY * this.factor, 0.0);
        context.scale(this.factor, this.factor, 1.0);
        context.translate(this.anchorX / this.factor, this.anchorY / this.factor, 0.0);
        this.restoreFunc = context::popMatrix;
    }

    public void apply(GuiRenderContext context) {
        context.pushMatrix();
        context.translate(-this.anchorX * this.factor, -this.anchorY * this.factor);
        context.scale(this.factor, this.factor);
        context.translate(this.anchorX / this.factor, this.anchorY / this.factor);
        this.restoreFunc = context::popMatrix;
    }

    public void restore() {
        if (this.restoreFunc == null) {
            throw new IllegalStateException("Scaler: Calling restore before calling apply");
        }
        this.restoreFunc.run();
        this.restoreFunc = null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public RenderContext getRenderContext() {
        return Objects.requireNonNull(this.context);
    }
}

