/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.minecraft;

import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.impl.compat.minecraft.world.level.dimension.DimensionWrapper;
import top.hendrixshen.magiclib.util.minecraft.ResourceLocationUtil;
import top.hendrixshen.magiclib.util.minecraft.StringUtil;

public class TextUtil {
    public static String tp(@NotNull Vec3 pos) {
        return String.format("/tp %s %s %s", pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    public static String tp(@NotNull Vec3i pos) {
        return String.format("/tp %d %d %d", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static String tp(@NotNull ChunkPos pos) {
        return String.format("/tp %d ~ %d", pos.f_45578_ * 16 + 8, pos.f_45579_ * 16 + 8);
    }

    @NotNull
    public static String tp(Vec3 pos, DimensionWrapper dimensionType) {
        return String.format("/execute in %s run", dimensionType) + TextUtil.tp(pos).replace('/', ' ');
    }

    @NotNull
    public static String tp(Vec3i pos, DimensionWrapper dimensionType) {
        return String.format("/execute in %s run", dimensionType) + TextUtil.tp(pos).replace('/', ' ');
    }

    @NotNull
    public static String tp(ChunkPos pos, DimensionWrapper dimensionType) {
        return String.format("/execute in %s run", dimensionType) + TextUtil.tp(pos).replace('/', ' ');
    }

    public static String tp(Entity entity) {
        if (entity instanceof Player) {
            String name = ((Player)entity).m_36316_().getName();
            return String.format("/tp %s", name);
        }
        String uuid = entity.m_142081_().toString();
        return String.format("/tp %s", uuid);
    }

    public static String coordinate(@NotNull Vec3 pos) {
        return String.format("[%.1f, %.1f, %.1f]", pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
    }

    public static String coordinate(@NotNull Vec3i pos) {
        return String.format("[%d, %d, %d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static String coordinate(@NotNull ChunkPos pos) {
        return String.format("[%d, %d]", pos.f_45578_, pos.f_45579_);
    }

    public static String vector(@NotNull Vec3 vec, int digits) {
        return String.format("(%s, %s, %s)", StringUtil.fractionDigit(vec.m_7096_(), digits), StringUtil.fractionDigit(vec.m_7098_(), digits), StringUtil.fractionDigit(vec.m_7094_(), digits));
    }

    public static String vector(Vec3 vec) {
        return TextUtil.vector(vec, 2);
    }

    public static String block(Block block) {
        return ResourceLocationUtil.id(block).toString();
    }

    @NotNull
    public static String block(BlockState blockState) {
        return BlockStateParser.m_116769_((BlockState)blockState);
    }

    public static <T extends Comparable<T>> String property(@NotNull Property<T> property, Object value) {
        return property.m_6940_((Comparable)value);
    }
}

