/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.comment;

import com.google.common.collect.ImmutableMap;
import fi.dy.masa.malilib.gui.GuiBase;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.impl.malilib.config.ConfigContainer;

public class TagProcessor {
    private static final Map<String, Transformer> TRANSFORMERS = ImmutableMap.of((Object)"tr", TagProcessor::transformTranslation, (Object)"config", TagProcessor::transformConfig);

    @NotNull
    public static String processReferences(ConfigContainer configContainer, String comment) {
        String patternString = "@([a-zA-Z0-9]+)#([a-zA-Z0-9.]+)@";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(comment);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String type = matcher.group(1);
            String value = matcher.group(2);
            Transformer transformer = TRANSFORMERS.getOrDefault(type, (s, c) -> matcher.group());
            matcher.appendReplacement(sb, transformer.transform(configContainer, value));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String transformTranslation(ConfigContainer configContainer, String translationKey) {
        return I18n.tr(translationKey);
    }

    private static String transformConfig(ConfigContainer configContainer, String configName) {
        if (configContainer.getConfigManager() == null) {
            return configName;
        }
        return configContainer.getConfigManager().getContainerByName(configName).map(config -> {
            String displayName = config.getConfig().getConfigGuiDisplayName();
            return GuiBase.TXT_YELLOW + displayName + GuiBase.TXT_RST;
        }).orElse(configName);
    }

    @FunctionalInterface
    private static interface Transformer {
        public String transform(ConfigContainer var1, String var2);
    }
}

