/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.statistic;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.i18n.I18n;

public class ConfigStatistic {
    private static final int USE_AMOUNT_INCREASE_COOLDOWN = 1000;
    public long lastUsedTime;
    public long useAmount;

    public ConfigStatistic() {
        this.reset();
    }

    public void reset() {
        this.lastUsedTime = 0L;
        this.useAmount = 0L;
    }

    public void loadFromJson(JsonElement jsonElement) {
        try {
            if (jsonElement.isJsonObject()) {
                JsonObject obj = jsonElement.getAsJsonObject();
                this.lastUsedTime = obj.get("lastUsedTime").getAsLong();
                this.useAmount = obj.get("useAmount").getAsLong();
            }
        }
        catch (Exception e) {
            MagicLib.getLogger().warn("Failed to load OptionStatistic from json '{}'", (Object)jsonElement);
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("lastUsedTime", (Number)this.lastUsedTime);
        obj.addProperty("useAmount", (Number)this.useAmount);
        return obj;
    }

    public void onConfigUsed() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUsedTime > 1000L) {
            ++this.useAmount;
        }
        this.lastUsedTime = currentTime;
    }

    public List<String> getDisplayLines() {
        Function<String, String> tr = name -> I18n.tr("magiclib.config.gui.statistic.entry." + name);
        String lastUsedTimeText = this.lastUsedTime <= 0L ? "N/A" : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.lastUsedTime));
        return Lists.newArrayList((Object[])new String[]{String.format("%s: %s", tr.apply("lastUsedTime"), lastUsedTimeText), String.format("%s: %d", tr.apply("useAmount"), this.useAmount)});
    }
}

