/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.mixin.minecraft.network.hook;

import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.hendrixshen.magiclib.api.network.packet.ClientboundPacketHandler;
import top.hendrixshen.magiclib.api.network.packet.PacketCodec;
import top.hendrixshen.magiclib.api.network.packet.PacketType;
import top.hendrixshen.magiclib.impl.network.packet.MagicCustomPayload;
import top.hendrixshen.magiclib.impl.network.packet.MagicPacketRegistry;
import top.hendrixshen.magiclib.impl.network.packet.PacketHandlerContextImpl;
import top.hendrixshen.magiclib.impl.network.packet.RegistryEntry;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.ClientboundCustomPayloadPacketAccessor;
import top.hendrixshen.magiclib.util.MiscUtil;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleClientboundCustomPayload(ClientboundCustomPayloadPacket packet, CallbackInfo ci) {
        ResourceLocation identifier = ((ClientboundCustomPayloadPacketAccessor)packet).magiclib$getIdentifier();
        PacketType packetId = PacketType.of(identifier);
        RegistryEntry entry = MagicPacketRegistry.CLIENTBOUND_GAME.getEntry(packetId);
        if (entry == null) {
            return;
        }
        FriendlyByteBuf buf = ((ClientboundCustomPayloadPacketAccessor)packet).magiclib$getData();
        try {
            MagicCustomPayload<FriendlyByteBuf> payload = new MagicCustomPayload<FriendlyByteBuf>((PacketType<FriendlyByteBuf>)packetId, (PacketCodec<FriendlyByteBuf>)entry.getCodec(), buf);
            ClientPacketListenerMixin.magiclib$handleCustomPayload(payload, entry.getHandler(), (ClientPacketListener)MiscUtil.cast(this));
            ci.cancel();
        }
        finally {
            buf.release();
        }
    }

    @Unique
    private static <P> void magiclib$handleCustomPayload(MagicCustomPayload<P> payload, ClientboundPacketHandler<P> handler, ClientPacketListener self) {
        handler.handle(payload.getPacket(), new PacketHandlerContextImpl.Clientbound(self));
    }
}

