/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.gui;

import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.api.malilib.config.option.ConfigVec3iList;
import top.hendrixshen.magiclib.impl.malilib.config.gui.MagicConfigGui;
import top.hendrixshen.magiclib.impl.malilib.config.gui.widget.WidgetListVec3iListEdit;
import top.hendrixshen.magiclib.impl.malilib.config.gui.widget.WidgetVec3iListEditEntry;

public class GuiVec3iListEdit
extends GuiListBase<Vec3i, WidgetVec3iListEditEntry, WidgetListVec3iListEdit> {
    protected final ConfigVec3iList config;
    protected final MagicConfigGui configGui;
    protected int dialogWidth;
    protected int dialogHeight;
    protected int dialogLeft;
    protected int dialogTop;
    @Nullable
    protected final IDialogHandler dialogHandler;

    public GuiVec3iListEdit(ConfigVec3iList config, MagicConfigGui configGui, @Nullable IDialogHandler dialogHandler, Screen parent) {
        super(0, 0);
        this.config = config;
        this.configGui = configGui;
        this.dialogHandler = dialogHandler;
        this.title = I18n.tr("magiclib.config.gui.title.vec3i_list_edit", config.getName());
        if (this.dialogHandler == null) {
            this.setParent(parent);
        }
    }

    protected void setWidthAndHeight() {
        this.dialogWidth = 400;
        this.dialogHeight = GuiUtils.getScaledWindowHeight() - 90;
    }

    protected void centerOnScreen() {
        if (this.getParent() != null) {
            this.dialogLeft = this.getParent().width / 2 - this.dialogWidth / 2;
            this.dialogTop = this.getParent().height / 2 - this.dialogHeight / 2;
        } else {
            this.dialogLeft = 20;
            this.dialogTop = 20;
        }
    }

    public void initGui() {
        this.setWidthAndHeight();
        this.centerOnScreen();
        this.reCreateListWidget();
        super.initGui();
    }

    protected int getBrowserWidth() {
        return this.dialogWidth - 14;
    }

    protected int getBrowserHeight() {
        return this.dialogHeight - 30;
    }

    protected WidgetListVec3iListEdit createListWidget(int x, int y) {
        return new WidgetListVec3iListEdit(this.dialogLeft + 10, this.dialogTop + 20, this.getBrowserWidth(), this.getBrowserHeight(), this.dialogWidth - 100, this);
    }

    public void removed() {
        if (((WidgetListVec3iListEdit)this.getListWidget()).wereConfigsModified()) {
            ((WidgetListVec3iListEdit)this.getListWidget()).applyPendingModifications();
            ConfigManager.getInstance().onConfigsChanged(this.configGui.getModId());
        }
        super.removed();
    }

    public void render(GuiGraphics poseStackOrGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.getParent() != null) {
            this.getParent().render(poseStackOrGuiGraphics, mouseX, mouseY, partialTicks);
        }
        super.render(poseStackOrGuiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void drawScreenBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderUtils.drawOutlinedBox((int)this.dialogLeft, (int)this.dialogTop, (int)this.dialogWidth, (int)this.dialogHeight, (int)-16777216, (int)-6710887);
    }

    protected void drawTitle(GuiGraphics poseStackOrGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.drawStringWithShadow(poseStackOrGuiGraphics, this.title, this.dialogLeft + 10, this.dialogTop + 6, -1);
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.dialogHandler != null) {
            this.dialogHandler.closeDialog();
            return true;
        }
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }

    @Generated
    public ConfigVec3iList getConfig() {
        return this.config;
    }
}

