/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.minecraft.render;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.StringSplitterAccessor;

@OnlyIn(value=Dist.CLIENT)
public class TextRenderUtil {
    @NotNull
    public static FormattedCharSequence string2formattedCharSequence(String string) {
        return visitor -> StringDecomposer.m_14346_((String)string, (Style)Style.f_131099_, (FormattedCharSink)visitor);
    }

    @NotNull
    public static String formattedCharSequence2string(@NotNull FormattedCharSequence text) {
        StringBuilder builder = new StringBuilder();
        text.m_13731_((index, style, codePoint) -> {
            builder.append((char)codePoint);
            return true;
        });
        return builder.toString();
    }

    public static FormattedCharSequence trim(@NotNull FormattedCharSequence text, int maxWidth, PostTrimModifier<FormattedCharSequence> postTrimModifier) {
        Font font = Minecraft.m_91087_().f_91062_;
        StringSplitter.WidthProvider widthRetriever = ((StringSplitterAccessor)font.m_92865_()).magiclib$widthProvider();
        ArrayList elements = Lists.newArrayList();
        MutableFloat width = new MutableFloat(0.0f);
        boolean hasTrimmed = text.m_13731_((index, style, codePoint) -> {
            boolean ok;
            width.add(widthRetriever.m_92515_(codePoint, style));
            boolean bl = ok = width.getValue().floatValue() <= (float)maxWidth;
            if (ok) {
                elements.add(Triple.of((Object)index, (Object)style, (Object)codePoint));
            }
            return ok;
        });
        FormattedCharSequence trimmedText = formattedCharSink -> {
            for (Triple element : elements) {
                if (formattedCharSink.m_6411_(((Integer)element.getLeft()).intValue(), (Style)element.getMiddle(), ((Integer)element.getRight()).intValue())) continue;
                return false;
            }
            return true;
        };
        if (hasTrimmed) {
            trimmedText = postTrimModifier.modify(trimmedText);
        }
        return trimmedText;
    }

    public static FormattedCharSequence trim(FormattedCharSequence text, int maxWidth) {
        return TextRenderUtil.trim(text, maxWidth, (FormattedCharSequence t) -> t);
    }

    public static String trim(String text, int maxWidth, PostTrimModifier<String> postTrimModifier) {
        Minecraft mc = Minecraft.m_91087_();
        String trimmedText = mc.f_91062_.m_92834_(text, maxWidth);
        if (trimmedText.length() < text.length()) {
            trimmedText = postTrimModifier.modify(trimmedText);
        }
        return trimmedText;
    }

    public static String trim(String text, int maxWidth) {
        return TextRenderUtil.trim(text, maxWidth, (String t) -> t);
    }

    @FunctionalInterface
    public static interface PostTrimModifier<T> {
        public T modify(T var1);
    }
}

