/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.compat.minecraft.network.chat;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ComponentCompat;
import top.hendrixshen.magiclib.impl.compat.minecraft.network.chat.HoverEventCompatImpl;
import top.hendrixshen.magiclib.util.collect.Provider;

public interface HoverEventCompat
extends Provider<HoverEvent> {
    @NotNull
    public static HoverEventCompat of(HoverEvent hoverEvent) {
        return new HoverEventCompatImpl(hoverEvent);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static <T> HoverEventCompat of(HoverEvent.Action<T> action, @NotNull Provider<T> object) {
        return HoverEventCompatImpl.of(action, object.get());
    }

    @NotNull
    public static HoverEvent showText(Component text) {
        return new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)text);
    }

    @NotNull
    public static HoverEventCompat showTextCompat(ComponentCompat text) {
        return HoverEventCompat.of(HoverEventCompat.showText((Component)text.get()));
    }

    @NotNull
    public static HoverEvent showItem(HoverEvent.ItemStackInfo itemStack) {
        return new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)itemStack);
    }

    @NotNull
    public static HoverEventCompat showItemCompat(HoverEvent.ItemStackInfo itemStack) {
        return HoverEventCompat.of(HoverEventCompat.showItem(itemStack));
    }

    @NotNull
    public static HoverEvent showEntity(HoverEvent.EntityTooltipInfo entityTooltip) {
        return new HoverEvent(HoverEvent.Action.SHOW_ENTITY, (Object)entityTooltip);
    }

    @NotNull
    public static HoverEventCompat showEntityCompat(HoverEvent.EntityTooltipInfo entityTooltip) {
        return HoverEventCompat.of(HoverEventCompat.showEntity(entityTooltip));
    }
}

