/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.render.context;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import top.hendrixshen.magiclib.api.render.context.GuiRenderContext;
import top.hendrixshen.magiclib.api.render.context.LevelRenderContext;
import top.hendrixshen.magiclib.api.render.matrix.MatrixStack;
import top.hendrixshen.magiclib.impl.render.context.GuiRenderContextImpl;
import top.hendrixshen.magiclib.impl.render.context.LevelRenderContextImpl;
import top.hendrixshen.magiclib.impl.render.matrix.JomlMatrixStack;
import top.hendrixshen.magiclib.impl.render.matrix.MinecraftPoseStack;

public interface RenderContext {
    public static LevelRenderContext level(@NotNull Matrix4fStack matrixStack) {
        return new LevelRenderContextImpl(new JomlMatrixStack(matrixStack));
    }

    public static GuiRenderContext gui(@NotNull GuiGraphics guiGraphics) {
        return new GuiRenderContextImpl(guiGraphics);
    }

    public static GuiRenderContext gui(@NotNull GuiGraphics guiGraphics, @NotNull PoseStack poseStack) {
        return new GuiRenderContextImpl(guiGraphics, new MinecraftPoseStack(poseStack));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public GuiGraphics getGuiComponent();

    public MatrixStack getMatrixStack();

    public void pushMatrix();

    public void popMatrix();

    public void translate(double var1, double var3, double var5);

    public void scale(double var1, double var3, double var5);

    public void mulPoseMatrix(Matrix4f var1);
}

