/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.migration;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.List;
import lombok.Generated;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigHandler;
import top.hendrixshen.magiclib.api.malilib.config.migration.ConfigMigrator;
import top.hendrixshen.magiclib.util.collect.SimplePredicate;

public class ConfigRelocationMigrator
implements ConfigMigrator {
    private final List<MigrationMapping> migrateMapping = Lists.newArrayList();
    private final SimplePredicate<MagicConfigHandler> migratePredicate;

    public ConfigRelocationMigrator(List<MigrationMapping> migrateMapping, SimplePredicate<MagicConfigHandler> migratePredicate) {
        this.migrateMapping.addAll(migrateMapping);
        this.migratePredicate = migratePredicate;
    }

    public void addMigrateMapping(String oldName, String oldCategory, String newName, String newCategory) {
        this.migrateMapping.add(new MigrationMapping(oldName, oldCategory, newName, newCategory));
    }

    public void addMigrateMapping(List<MigrationMapping> migrateMapping) {
        this.migrateMapping.addAll(migrateMapping);
    }

    @Override
    public boolean migrate(MagicConfigHandler configHandler) {
        JsonObject loadedJson = configHandler.getLoadedJson();
        boolean isMigrated = false;
        for (MigrationMapping mapping : this.migrateMapping) {
            JsonObject oldCategoryObj = JsonUtils.getNestedObject((JsonObject)loadedJson, (String)mapping.getOldCategory(), (boolean)false);
            if (oldCategoryObj == null) {
                MagicLib.getLogger().warn("[ConfigRelocationMigrator-{}]Skipped migrate config, because source category does not exist(source={}.{}, destination={}.{}).", (Object)configHandler.getIdentifier(), (Object)mapping.getOldCategory(), (Object)mapping.getOldName(), (Object)mapping.getNewCategory(), (Object)mapping.getNewName());
                continue;
            }
            JsonElement oldConfigObj = oldCategoryObj.get(mapping.getOldName());
            if (oldConfigObj == null) {
                MagicLib.getLogger().warn("[ConfigRelocationMigrator-{}]Skipped migrate config, because source config does not exist(source={}.{}, destination={}.{}).", (Object)configHandler.getIdentifier(), (Object)mapping.getOldCategory(), (Object)mapping.getOldName(), (Object)mapping.getNewCategory(), (Object)mapping.getNewName());
                continue;
            }
            JsonObject newCategoryObj = JsonUtils.getNestedObject((JsonObject)loadedJson, (String)mapping.getNewCategory(), (boolean)true);
            assert (newCategoryObj != null);
            if (newCategoryObj.has(mapping.getNewName())) {
                MagicLib.getLogger().warn("[ConfigRelocationMigrator-{}]Skipped migrate config, because destination config already exists(source={}.{}, destination={}.{}).", (Object)configHandler.getIdentifier(), (Object)mapping.getOldCategory(), (Object)mapping.getOldName(), (Object)mapping.getNewCategory(), (Object)mapping.getNewName());
                continue;
            }
            newCategoryObj.add(mapping.getNewName(), oldConfigObj);
            isMigrated = true;
            MagicLib.getLogger().info("[ConfigRelocationMigrator-{}]Migrated config {}.{} -> {}.{}", (Object)configHandler.getIdentifier(), (Object)mapping.getOldCategory(), (Object)mapping.getOldName(), (Object)mapping.getNewCategory(), (Object)mapping.getNewName());
        }
        return isMigrated;
    }

    @Override
    public boolean shouldMigrate(MagicConfigHandler configHandler) {
        return this.migratePredicate.test(configHandler);
    }

    public static class MigrationMapping {
        private final String oldCategory;
        private final String oldName;
        private final String newCategory;
        private final String newName;

        @Generated
        public MigrationMapping(String oldCategory, String oldName, String newCategory, String newName) {
            this.oldCategory = oldCategory;
            this.oldName = oldName;
            this.newCategory = newCategory;
            this.newName = newName;
        }

        @Generated
        public String getOldCategory() {
            return this.oldCategory;
        }

        @Generated
        public String getOldName() {
            return this.oldName;
        }

        @Generated
        public String getNewCategory() {
            return this.newCategory;
        }

        @Generated
        public String getNewName() {
            return this.newName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MigrationMapping)) {
                return false;
            }
            MigrationMapping other = (MigrationMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$oldCategory = this.getOldCategory();
            String other$oldCategory = other.getOldCategory();
            if (this$oldCategory == null ? other$oldCategory != null : !this$oldCategory.equals(other$oldCategory)) {
                return false;
            }
            String this$oldName = this.getOldName();
            String other$oldName = other.getOldName();
            if (this$oldName == null ? other$oldName != null : !this$oldName.equals(other$oldName)) {
                return false;
            }
            String this$newCategory = this.getNewCategory();
            String other$newCategory = other.getNewCategory();
            if (this$newCategory == null ? other$newCategory != null : !this$newCategory.equals(other$newCategory)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MigrationMapping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $oldCategory = this.getOldCategory();
            result = result * 59 + ($oldCategory == null ? 43 : $oldCategory.hashCode());
            String $oldName = this.getOldName();
            result = result * 59 + ($oldName == null ? 43 : $oldName.hashCode());
            String $newCategory = this.getNewCategory();
            result = result * 59 + ($newCategory == null ? 43 : $newCategory.hashCode());
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConfigRelocationMigrator.MigrationMapping(oldCategory=" + this.getOldCategory() + ", oldName=" + this.getOldName() + ", newCategory=" + this.getNewCategory() + ", newName=" + this.getNewName() + ")";
        }
    }
}

