/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.render.context;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.GuiRenderer;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.fog.FogRenderer;
import top.hendrixshen.magiclib.api.fake.render.InWorldGuiRendererHook;
import top.hendrixshen.magiclib.util.function.MemoizedSupplier;
import top.hendrixshen.magiclib.util.minecraft.render.RenderUtil;

public class InWorldGuiDrawer
implements AutoCloseable {
    private static boolean initializing = false;
    private static final MemoizedSupplier<InWorldGuiDrawer> INSTANCE = new MemoizedSupplier<InWorldGuiDrawer>(() -> {
        initializing = true;
        InWorldGuiDrawer inst = new InWorldGuiDrawer();
        initializing = false;
        return inst;
    });
    private final GuiGraphics guiGraphics;
    private final GuiRenderState guiState;
    private final GuiRenderer guiRenderer;
    private final FogRenderer fogRenderer;

    private InWorldGuiDrawer() {
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource immediate = RenderUtil.getBufferSource();
        this.guiState = new GuiRenderState();
        this.guiGraphics = new GuiGraphics(mc, this.guiState);
        this.guiRenderer = new GuiRenderer(this.guiState, immediate, (SubmitNodeCollector)mc.gameRenderer.getSubmitNodeStorage(), mc.gameRenderer.getFeatureRenderDispatcher(), List.of());
        ((InWorldGuiRendererHook)this.guiRenderer).magiclib$setInWorldGuiRender(true);
        this.fogRenderer = new FogRenderer();
    }

    public static InWorldGuiDrawer getInstance() {
        return INSTANCE.get();
    }

    public static void closeInstance() {
        if (INSTANCE.hasValue()) {
            INSTANCE.get().close();
        }
    }

    public void render() {
        RenderSystem.backupProjectionMatrix();
        this.guiRenderer.render(this.fogRenderer.getBuffer(FogRenderer.FogMode.NONE));
        RenderSystem.restoreProjectionMatrix();
        this.guiRenderer.incrementFrameNumber();
        this.fogRenderer.endFrame();
        this.guiState.reset();
    }

    @Override
    public void close() {
        this.guiRenderer.close();
        this.fogRenderer.close();
    }

    @Generated
    public static boolean isInitializing() {
        return initializing;
    }

    @Generated
    public GuiGraphics getGuiGraphics() {
        return this.guiGraphics;
    }
}

