/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.compat.minecraft.network.chat;

import java.net.URI;
import net.minecraft.network.chat.ClickEvent;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.impl.compat.minecraft.network.chat.ClickEventCompatImpl;
import top.hendrixshen.magiclib.util.collect.Provider;

public interface ClickEventCompat
extends Provider<ClickEvent> {
    @NotNull
    public static ClickEventCompat of(ClickEvent clickEvent) {
        return new ClickEventCompatImpl(clickEvent);
    }

    @NotNull
    public static ClickEvent openUrl(String url) {
        return new ClickEvent.OpenUrl(URI.create(url));
    }

    @NotNull
    public static ClickEventCompat openUrlCompat(String url) {
        return ClickEventCompat.of(ClickEventCompat.openUrl(url));
    }

    @NotNull
    public static ClickEvent openFile(String file) {
        return new ClickEvent.OpenFile(file);
    }

    @NotNull
    public static ClickEventCompat openFileCompat(String file) {
        return ClickEventCompat.of(ClickEventCompat.openFile(file));
    }

    @NotNull
    public static ClickEvent runCommand(String command) {
        return new ClickEvent.RunCommand(command);
    }

    @NotNull
    public static ClickEventCompat runCommandCompat(String command) {
        return ClickEventCompat.of(ClickEventCompat.runCommand(command));
    }

    @NotNull
    public static ClickEvent suggestCommand(String command) {
        return new ClickEvent.SuggestCommand(command);
    }

    @NotNull
    public static ClickEventCompat suggestCommandCompat(String command) {
        return ClickEventCompat.of(ClickEventCompat.suggestCommand(command));
    }

    @NotNull
    public static ClickEvent changePage(String page) {
        return new ClickEvent.ChangePage(Integer.parseInt(page));
    }

    @NotNull
    public static ClickEventCompat changePageCompat(String page) {
        return ClickEventCompat.of(ClickEventCompat.changePage(page));
    }

    @NotNull
    public static ClickEvent copyToClipboard(String text) {
        return new ClickEvent.CopyToClipboard(text);
    }

    @NotNull
    public static ClickEventCompat copyToClipboardCompat(String text) {
        return ClickEventCompat.of(ClickEventCompat.copyToClipboard(text));
    }
}

