/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.event.minecraft.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.compat.minecraft.util.ProfilerCompat;
import top.hendrixshen.magiclib.api.event.Event;
import top.hendrixshen.magiclib.api.event.minecraft.render.RenderEntityListener;
import top.hendrixshen.magiclib.impl.render.context.EntityRenderContext;
import top.hendrixshen.magiclib.impl.render.matrix.MinecraftPoseStack;

public class RenderEntityEvent {

    public static class PostRender
    implements Event<RenderEntityListener> {
        private final Info info;

        public PostRender(Info info) {
            this.info = info;
        }

        @Override
        public void dispatch(@NotNull List<RenderEntityListener> listeners) {
            ProfilerCompat.get().push("Magiclib#PostEntityRenderHook");
            for (RenderEntityListener listener : listeners) {
                listener.postRenderEntity(this.info.entity, this.info.renderContext);
            }
            ProfilerCompat.get().pop();
        }

        @Override
        public Class<RenderEntityListener> getListenerType() {
            return RenderEntityListener.class;
        }
    }

    public static class PreRender
    implements Event<RenderEntityListener> {
        private final Info info;

        public PreRender(Info info) {
            this.info = info;
        }

        @Override
        public void dispatch(@NotNull List<RenderEntityListener> listeners) {
            ProfilerCompat.get().push("Magiclib#PreEntityRenderHook");
            for (RenderEntityListener listener : listeners) {
                listener.preRenderEntity(this.info.entity, this.info.renderContext);
            }
            ProfilerCompat.get().pop();
        }

        @Override
        public Class<RenderEntityListener> getListenerType() {
            return RenderEntityListener.class;
        }
    }

    public static class Info {
        @NotNull
        private final Entity entity;
        @NotNull
        private final EntityRenderContext renderContext;

        public static Info of(Entity entity, PoseStack poseStack) {
            return new Info(entity, new EntityRenderContext(new MinecraftPoseStack(poseStack)));
        }

        @Generated
        private Info(@NotNull Entity entity, @NotNull EntityRenderContext renderContext) {
            if (entity == null) {
                throw new NullPointerException("entity is marked non-null but is null");
            }
            if (renderContext == null) {
                throw new NullPointerException("renderContext is marked non-null but is null");
            }
            this.entity = entity;
            this.renderContext = renderContext;
        }
    }
}

