/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib;

import java.util.Comparator;
import org.jetbrains.annotations.ApiStatus;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.impl.mixin.audit.MixinAuditor;
import top.hendrixshen.magiclib.util.SystemUtil;

public final class MagicLibProperties {
    public static final SystemUtil.Option ROOT = SystemUtil.Option.newOption("magiclib");
    public static final SystemUtil.Option DEBUG = SystemUtil.Option.newOption(ROOT, SystemUtil.Option.InheritType.INDEPENDENT, "debug");
    public static final SystemUtil.Option MIXIN_AUDITOR = SystemUtil.Option.newOption(DEBUG, SystemUtil.Option.InheritType.INDEPENDENT, "mixinAuditor");
    public static final SystemUtil.Option MIXIN_AUDITOR_ENABLE = SystemUtil.Option.newOption(MIXIN_AUDITOR, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "enable");
    public static final SystemUtil.Option MIXIN_AUDITOR_EXIT_MODE = SystemUtil.Option.newOption(MIXIN_AUDITOR, SystemUtil.Option.InheritType.INDEPENDENT, "exitMode", String.valueOf((Object)MixinAuditor.ExitMode.DEFAULT));
    public static final SystemUtil.Option MIXIN_AUDITOR_FAIL_CODE = SystemUtil.Option.newOption(MIXIN_AUDITOR, SystemUtil.Option.InheritType.INDEPENDENT, "failCode", String.valueOf(-1296387927));
    public static final SystemUtil.Option MIXIN_AUDITOR_TRIGGER = SystemUtil.Option.newOption(MIXIN_AUDITOR, SystemUtil.Option.InheritType.INDEPENDENT, "trigger", "mod_init");
    public static final SystemUtil.Option DEV = SystemUtil.Option.newOption(ROOT, SystemUtil.Option.InheritType.INDEPENDENT, "dev");
    public static final SystemUtil.Option DEV_MAPPING = SystemUtil.Option.newOption(DEV, SystemUtil.Option.InheritType.INDEPENDENT, "mapping", null);
    public static final SystemUtil.Option DEV_MAPPING_NAME = SystemUtil.Option.newOption(DEV_MAPPING, SystemUtil.Option.InheritType.INDEPENDENT, "name", null);
    public static final SystemUtil.Option DEV_QOL = SystemUtil.Option.newOption(DEV, SystemUtil.Option.InheritType.INDEPENDENT, "qol");
    public static final SystemUtil.Option DEV_QOL_AUTH = SystemUtil.Option.newOption(DEV_QOL, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "auth");
    public static final SystemUtil.Option DEV_QOL_AUTH_EMPTY_KEY = SystemUtil.Option.newOption(DEV_QOL_AUTH, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "emptyKey");
    public static final SystemUtil.Option DEV_QOL_AUTH_SILENT_VERIFY_ERROR = SystemUtil.Option.newOption(DEV_QOL_AUTH, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "silentVerify");
    public static final SystemUtil.Option DEV_QOL_CHUNK = SystemUtil.Option.newOption(DEV_QOL, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "chunk");
    public static final SystemUtil.Option DEV_QOL_DFU = SystemUtil.Option.newOption(DEV_QOL, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "dfu");
    public static final SystemUtil.Option DEV_QOL_DFU_LAZY = SystemUtil.Option.newOption(DEV_QOL_DFU, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "lazy");
    public static final SystemUtil.Option DEV_QOL_DFU_BREAK = SystemUtil.Option.newOption(DEV_QOL_DFU, SystemUtil.Option.InheritType.INDEPENDENT, "destroy");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK = SystemUtil.Option.newOption(DEV_QOL, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "threadTweak");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_COUNT = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK, SystemUtil.Option.InheritType.INDEPENDENT, "count");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_COUNT_BOOTSTRAP = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK_COUNT, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "bootstrap", "1");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_COUNT_MAIN = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK_COUNT, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "main", String.valueOf(MagicLibProperties.getMaxBackgroundThreads()));
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_PRIORITY = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK, SystemUtil.Option.InheritType.INDEPENDENT, "priority");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_PRIORITY_BOOTSTRAP = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK_PRIORITY, SystemUtil.Option.InheritType.INDEPENDENT, "bootstrap", "1");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_PRIORITY_GAME = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK_PRIORITY, SystemUtil.Option.InheritType.INDEPENDENT, "game", "5");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_PRIORITY_INTEGRATED_SERVER = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK_PRIORITY, SystemUtil.Option.InheritType.INDEPENDENT, "integratedServer", "5");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_PRIORITY_IO = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK_PRIORITY, SystemUtil.Option.InheritType.INDEPENDENT, "io", "1");
    public static final SystemUtil.Option DEV_QOL_THREAD_TWEAK_PRIORITY_MAIN = SystemUtil.Option.newOption(DEV_QOL_THREAD_TWEAK_PRIORITY, SystemUtil.Option.InheritType.INDEPENDENT, "main", "1");
    public static final SystemUtil.Option DEV_MALILIB = SystemUtil.Option.newOption(DEV, SystemUtil.Option.InheritType.INDEPENDENT, "malilib");
    public static final SystemUtil.Option DEV_MALILIB_CHECK = SystemUtil.Option.newOption(DEV_MALILIB, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "check");
    public static final SystemUtil.Option MALILIB_CHECK_CONFIG = SystemUtil.Option.newOption(DEV_MALILIB_CHECK, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "config");
    public static final SystemUtil.Option MALILIB_CHECK_CONFIG_NAME = SystemUtil.Option.newOption(MALILIB_CHECK_CONFIG, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "name");
    public static final SystemUtil.Option MALILIB_CHECK_CONFIG_NAME_EMPTY = SystemUtil.Option.newOption(MALILIB_CHECK_CONFIG_NAME, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "empty");
    public static final SystemUtil.Option MALILIB_CHECK_CONFIG_NAME_CONSISTENCY = SystemUtil.Option.newOption(MALILIB_CHECK_CONFIG_NAME, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "consistency");
    public static final SystemUtil.Option MALILIB_CHECK_CONFIG_FIELD_FINAL = SystemUtil.Option.newOption(MALILIB_CHECK_CONFIG, SystemUtil.Option.InheritType.ALLOW_OVERRIDE, "fieldFinal");

    @ApiStatus.Internal
    public static void printDetail() {
        if (!DEBUG.getBooleanValue()) {
            return;
        }
        MagicLib.getLogger().warn("MagicLib properties stats: ");
        SystemUtil.getProperties().stream().sorted(Comparator.comparing(SystemUtil.Option::getProperty)).forEach(option -> {
            StringBuilder indent = new StringBuilder();
            for (int i = 0; i < option.getDepth(); ++i) {
                indent.append("- ");
            }
            MagicLib.getLogger().warn("{}{}: {}", (Object)indent.toString(), (Object)option.getProperty(), option);
        });
    }

    public static int getMaxBackgroundThreads() {
        String string = System.getProperty("max.bg.threads");
        if (string == null) {
            return 255;
        }
        try {
            int i = Integer.parseInt(string);
            if (i < 1) {
                return 1;
            }
            return Math.min(i, 255);
        }
        catch (NumberFormatException e) {
            return 255;
        }
    }
}

