/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.compat.minecraft.client.gui.components;

import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.ComponentCompat;
import top.hendrixshen.magiclib.api.compat.minecraft.network.chat.MutableComponentCompat;
import top.hendrixshen.magiclib.util.collect.Provider;

@OnlyIn(value=Dist.CLIENT)
public interface ButtonCompat
extends Provider<Button> {
    public static @NotNull Builder builder(@NotNull Component message, @NotNull OnPress onPress) {
        return new Builder(message, onPress);
    }

    public static @NotNull Builder builder(@NotNull ComponentCompat message, @NotNull OnPress onPress) {
        return new Builder((Component)message.get(), onPress);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Component message;
        private final OnPress onPress;
        private int x;
        private int y;
        private int height = 20;
        private int width = 150;

        public Builder(@NotNull Component message, @NotNull OnPress onPress) {
            this.message = message;
            this.onPress = onPress;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            return this.size(this.width, height);
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            this.pos(x, y).size(width, height);
            return this;
        }

        public Builder tooltip(@Nullable Object tooltip) {
            return this;
        }

        public Builder createNarration(Object narration) {
            return this;
        }

        public Button build() {
            return new Button(this.x, this.y, this.width, this.height, this.message, this.onPress::onPress);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(Button var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CreateNarration {
        public MutableComponentCompat createNarrationMessage(Supplier<MutableComponentCompat> var1);
    }
}

