/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.malilib.config.option;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import java.util.Arrays;
import top.hendrixshen.magiclib.api.i18n.I18n;

public interface EnumOptionEntry
extends IConfigOptionListEntry {
    public String name();

    public int ordinal();

    public EnumOptionEntry[] getAllValues();

    public EnumOptionEntry getDefault();

    public String getTranslationPrefix();

    default public String getStringValue() {
        return this.name().toLowerCase();
    }

    default public String getDisplayName() {
        return I18n.translateOrFallback(String.format("%s.value.%s", this.getTranslationPrefix(), this.name()), this.name());
    }

    default public IConfigOptionListEntry cycle(boolean forward) {
        int index = this.ordinal();
        EnumOptionEntry[] values = this.getAllValues();
        index += forward ? 1 : -1;
        index = (index + values.length) % values.length;
        return values[index];
    }

    default public IConfigOptionListEntry fromString(String value) {
        return Arrays.stream(this.getAllValues()).filter(o -> o.name().equalsIgnoreCase(value)).findFirst().orElseGet(this::getDefault);
    }
}

