/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.i18n.minecraft;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.Pack;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.fake.i18n.PackAccessor;
import top.hendrixshen.magiclib.api.i18n.LanguageProvider;
import top.hendrixshen.magiclib.impl.i18n.provider.FileLanguageProvider;
import top.hendrixshen.magiclib.impl.i18n.provider.JarLanguageProvider;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.LegacyPackResourcesAdapterAccessor;
import top.hendrixshen.magiclib.mixin.minecraft.accessor.PackResourcesAdapterV4Accessor;
import top.hendrixshen.magiclib.util.JsonUtil;

public class ResourceLanguageProvider
implements LanguageProvider {
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, Map<String, String>> languageMap = Maps.newConcurrentMap();

    @Override
    public void init() {
        this.languageMap.clear();
        Minecraft.m_91087_().m_91099_().m_10524_().stream().filter(pack -> pack.m_10446_().startsWith("file")).map(Pack::m_10445_).map(this::adaptPack).filter(Objects::nonNull).forEach(this::initLanguageMap);
    }

    @Override
    public void reload() {
        this.init();
    }

    @Override
    public void reload(String LanguageCode) {
        this.reload();
    }

    @Override
    public void loadLanguage(String languageCode) {
    }

    @Override
    public Map<String, String> getLanguage(String languageCode) {
        return this.languageMap.getOrDefault(languageCode, Collections.emptyMap());
    }

    private PackAccessor adaptPack(PackResources packResources) {
        return this.adaptPack(packResources, false);
    }

    private PackAccessor adaptPack(PackResources packResources, boolean recursive) {
        if (packResources instanceof PackAccessor) {
            return (PackAccessor)packResources;
        }
        if (packResources instanceof LegacyPackResourcesAdapterAccessor) {
            PackAccessor packAccessor;
            block20: {
                PackResources v3PackRes = ((LegacyPackResourcesAdapterAccessor)packResources).magiclib$getSource();
                try {
                    packAccessor = this.adaptPack(v3PackRes, true);
                    if (v3PackRes == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (v3PackRes != null) {
                            try {
                                v3PackRes.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        MagicLib.getLogger().error("Failed to unpack v3adapter {}.", (Object)packResources.m_8017_(), (Object)e);
                        return null;
                    }
                }
                v3PackRes.close();
            }
            return packAccessor;
        }
        if (packResources instanceof PackResourcesAdapterV4Accessor) {
            PackAccessor packAccessor;
            block21: {
                PackResources v4PackRes = ((PackResourcesAdapterV4Accessor)packResources).magiclib$getPack();
                try {
                    packAccessor = this.adaptPack(v4PackRes, true);
                    if (v4PackRes == null) break block21;
                }
                catch (Throwable throwable) {
                    try {
                        if (v4PackRes != null) {
                            try {
                                v4PackRes.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        MagicLib.getLogger().error("Failed to unpack v4adapter {}.", (Object)packResources.m_8017_(), (Object)e);
                        return null;
                    }
                }
                v4PackRes.close();
            }
            return packAccessor;
        }
        if (!recursive) {
            MagicLib.getLogger().error("Failed to unpack {}.", (Object)packResources.m_8017_());
        }
        return null;
    }

    private void initLanguageMap(PackAccessor pack) {
        if (pack instanceof FolderPackResources) {
            this.loadFromFolderPack(pack.magiclib$getFile().toPath());
        } else if (pack instanceof FilePackResources) {
            this.loadFromZipPack(pack.magiclib$getFile());
        } else {
            MagicLib.getLogger().error("Unknown resource the type of pack {}.", (Object)((PackResources)pack).m_8017_());
        }
    }

    private void loadFromZipPack(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
                try {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    try {
                        if (!JarLanguageProvider.loadFromEntry(zipEntry, inputStream, languageCode -> this.languageMap.computeIfAbsent((String)languageCode, k -> Maps.newConcurrentMap()))) continue;
                        MagicLib.getLogger().debug("Loaded language file {} from {}.", (Object)zipEntry.getName(), (Object)file.getName());
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    MagicLib.getLogger().error("Failed to load language file {} from {}.", (Object)zipEntry.getName(), (Object)zipFile.getName(), (Object)e);
                }
            }
        }
        catch (IOException e) {
            MagicLib.getLogger().error("Failed to load language file from {}.", (Object)file.getName(), (Object)e);
        }
    }

    private void loadFromFolderPack(Path path) {
        try {
            ConcurrentMap files = Maps.newConcurrentMap();
            Files.walkFileTree(path, new FileLanguageProvider.LanguageFileVisitor(path, files, true));
            for (Map.Entry entry : files.entrySet()) {
                Map map = this.languageMap.computeIfAbsent((String)entry.getKey(), k -> Maps.newConcurrentMap());
                for (Path p : (List)entry.getValue()) {
                    InputStream inputStream = Files.newInputStream(p, new OpenOption[0]);
                    try {
                        JsonUtil.loadStringMapFromJson(inputStream, map::put);
                        MagicLib.getLogger().debug("Loaded language file {}.", (Object)path);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            MagicLib.getLogger().error("Failed to load language file {}.", (Object)path, (Object)e);
        }
    }

    @Generated
    private ResourceLanguageProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ResourceLanguageProvider getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ResourceLanguageProvider actualValue = new ResourceLanguageProvider();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ResourceLanguageProvider)($value == instance ? null : $value);
    }
}

