/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.MagicLibProperties;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigManager;
import top.hendrixshen.magiclib.api.malilib.config.option.MagicIConfigBase;
import top.hendrixshen.magiclib.impl.malilib.config.ConfigContainer;
import top.hendrixshen.magiclib.impl.malilib.config.GlobalConfigManager;
import top.hendrixshen.magiclib.impl.malilib.config.MagicConfigFactory;
import top.hendrixshen.magiclib.impl.malilib.config.gui.MagicConfigGui;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public class MagicConfigManagerImpl
implements MagicConfigManager,
IKeybindProvider {
    private final MagicConfigFactory configFactory;
    private final String identifier;
    private final MagicConfigGui.GuiSetting guiSetting = new MagicConfigGui.GuiSetting();
    private final List<ConfigContainer> CONTAINERS = Lists.newArrayList();
    private final Set<String> CATEGORIES = Sets.newLinkedHashSet();
    private final Map<String, List<ConfigContainer>> CATEGORY_TO_CONTAINERS = Maps.newLinkedHashMap();
    private final Map<MagicIConfigBase, ConfigContainer> CONFIG_TO_CONTAINER = Maps.newLinkedHashMap();
    private final Map<String, ConfigContainer> NAME_TO_CONTAINER = Maps.newLinkedHashMap();

    protected MagicConfigManagerImpl(String identifier) {
        this.identifier = identifier;
        this.configFactory = new MagicConfigFactory(identifier);
        this.CATEGORIES.add("all");
    }

    @Override
    public final void parseConfigClass(@NotNull Class<?> configClass) {
        for (Field field : configClass.getDeclaredFields()) {
            if (!ConfigContainer.isValidFieldAnnotation(field)) continue;
            if (!ConfigContainer.isValidFieldObject(field)) {
                MagicLib.getLogger().warn("{} is not a subclass of MagicIConfigBase, skipping!", (Object)field.getName());
                continue;
            }
            ConfigContainer configContainer = ConfigContainer.createRegulated(field, this);
            if (this.NAME_TO_CONTAINER.containsKey(configContainer.getName())) {
                MagicLib.getLogger().error("Config {} already exists", (Object)configContainer.getName());
                continue;
            }
            if (MagicLibProperties.MALILIB_CHECK_CONFIG_NAME_EMPTY.getBooleanValue() && configContainer.getName().isEmpty()) {
                MagicLib.getLogger().warn("Config name is empty (field name = {})!", (Object)field.getName());
            }
            if (MagicLibProperties.MALILIB_CHECK_CONFIG_NAME_CONSISTENCY.getBooleanValue() && !configContainer.getName().equals(field.getName())) {
                MagicLib.getLogger().warn("Config name {} does not match field name {}!", (Object)configContainer.getName(), (Object)field.getName());
            }
            if (MagicLibProperties.MALILIB_CHECK_CONFIG_FIELD_FINAL.getBooleanValue() && !Modifier.isFinal(field.getModifiers())) {
                MagicLib.getLogger().warn("Field {} should be final!", (Object)field.getName());
            }
            this.CONTAINERS.add(configContainer);
            this.CATEGORIES.add(configContainer.getCategory());
            this.CATEGORY_TO_CONTAINERS.computeIfAbsent(configContainer.getCategory(), category -> Lists.newArrayList()).add(configContainer);
            this.CONFIG_TO_CONTAINER.put(configContainer.getConfig(), configContainer);
            this.NAME_TO_CONTAINER.put(configContainer.getName(), configContainer);
            GlobalConfigManager.getInstance().registerConfigContainer(configContainer);
        }
    }

    @Override
    public Collection<String> getCategories() {
        return Lists.newArrayList(this.CATEGORIES);
    }

    @Override
    public Collection<ConfigContainer> getContainers(@NotNull String category) {
        if (category.equals("all")) {
            return this.CONTAINERS;
        }
        return this.CATEGORY_TO_CONTAINERS.getOrDefault(category, Collections.emptyList());
    }

    @Override
    public Collection<ConfigContainer> getAllContainers() {
        return Lists.newArrayList(this.CONTAINERS);
    }

    @Override
    public ValueContainer<ConfigContainer> getContainerByConfig(MagicIConfigBase config) {
        return ValueContainer.ofNullable(this.CONFIG_TO_CONTAINER.getOrDefault(config, null));
    }

    @Override
    public ValueContainer<ConfigContainer> getContainerByName(String name) {
        return ValueContainer.ofNullable(this.NAME_TO_CONTAINER.getOrDefault(name, null));
    }

    @Override
    public List<IHotkey> getAllCustomHotkeys() {
        return this.CONTAINERS.stream().map(ConfigContainer::getConfig).filter(IHotkey.class::isInstance).map(IHotkey.class::cast).collect(Collectors.toList());
    }

    @Override
    public boolean hasConfig(String name) {
        return this.getContainerByName(name).isPresent();
    }

    @Override
    public void onConfigLoaded() {
    }

    public void addKeysToMap(IKeybindManager iKeybindManager) {
        this.getAllCustomHotkeys().forEach(iHotkey -> iKeybindManager.addKeybindToMap(iHotkey.getKeybind()));
    }

    public void addHotkeys(@NotNull IKeybindManager iKeybindManager) {
        iKeybindManager.addHotkeysForCategory(this.identifier, String.format("%s.hotkeys.category.main", this.identifier), this.getAllCustomHotkeys());
    }

    @Override
    @Generated
    public MagicConfigFactory getConfigFactory() {
        return this.configFactory;
    }

    @Override
    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @Generated
    public MagicConfigGui.GuiSetting getGuiSetting() {
        return this.guiSetting;
    }
}

