/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.malilib.config.migration;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.JsonUtils;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.malilib.config.MagicConfigHandler;
import top.hendrixshen.magiclib.api.malilib.config.migration.ConfigMigrator;
import top.hendrixshen.magiclib.util.collect.SimplePredicate;

public class VersionMigrator
implements ConfigMigrator {
    private final int newVersion;
    private final SimplePredicate<MagicConfigHandler> migratePredicate;

    public VersionMigrator(int newVersion, SimplePredicate<MagicConfigHandler> migratePredicate) {
        this.newVersion = newVersion;
        this.migratePredicate = migratePredicate;
    }

    @Override
    public boolean migrate(MagicConfigHandler configHandler) {
        JsonObject loadedJson = configHandler.getLoadedJson();
        int oldVersion = VersionMigrator.tryGetConfigVersion(loadedJson);
        if (oldVersion == this.newVersion) {
            MagicLib.getLogger().info("[VersionMigrator-{}]Cannot migrant to same version {}", (Object)configHandler.getIdentifier(), (Object)this.newVersion);
            return false;
        }
        JsonObject internal = JsonUtils.getNestedObject((JsonObject)loadedJson, (String)"internal", (boolean)true);
        assert (internal != null);
        JsonObject global = JsonUtils.getNestedObject((JsonObject)internal, (String)"global", (boolean)true);
        assert (global != null);
        global.addProperty("config_version", (Number)this.newVersion);
        internal.add("global", (JsonElement)global);
        loadedJson.add("internal", (JsonElement)internal);
        MagicLib.getLogger().info("[VersionMigrator-{}]Migrated config version from {} to {}", (Object)configHandler.getIdentifier(), oldVersion >= 0 ? Integer.valueOf(oldVersion) : "unknown", (Object)this.newVersion);
        return true;
    }

    @Override
    public boolean shouldMigrate(MagicConfigHandler configHandler) {
        return this.migratePredicate.test(configHandler);
    }

    public static int tryGetConfigVersion(JsonObject root) {
        JsonObject internal = JsonUtils.getNestedObject((JsonObject)root, (String)"internal", (boolean)false);
        if (internal != null) {
            JsonObject global = JsonUtils.getNestedObject((JsonObject)internal, (String)"global", (boolean)false);
            if (global == null) {
                return -1;
            }
            return JsonUtils.getIntegerOrDefault((JsonObject)global, (String)"config_version", (int)-1);
        }
        return JsonUtils.getIntegerOrDefault((JsonObject)root, (String)"configVersion", (int)-1);
    }
}

