/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.mixin.extension;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.mixin.transformer.meta.MixinMerged;
import org.spongepowered.asm.util.Annotations;
import top.hendrixshen.magiclib.api.mixin.annotation.MagicInit;
import top.hendrixshen.magiclib.api.mixin.annotation.SuperInit;
import top.hendrixshen.magiclib.api.mixin.annotation.ThisInit;
import top.hendrixshen.magiclib.api.mixin.extension.EmptyExtension;
import top.hendrixshen.magiclib.util.mixin.MixinUtil;

public final class MagicInitExtension
extends EmptyExtension {
    @Override
    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    @Override
    public void postApply(@NotNull ITargetClassContext context) {
        ClassNode classNode = context.getClassNode();
        HashSet thisInitMethods = Sets.newHashSet();
        HashSet superInitMethods = Sets.newHashSet();
        for (MethodNode methodNode : classNode.methods) {
            AnnotationNode thisInit = Annotations.getInvisible((MethodNode)methodNode, ThisInit.class);
            AnnotationNode superInit = Annotations.getInvisible((MethodNode)methodNode, SuperInit.class);
            if (thisInit != null) {
                thisInitMethods.add(methodNode);
            }
            if (superInit == null) continue;
            superInitMethods.add(methodNode);
        }
        classNode.methods.removeAll(thisInitMethods);
        classNode.methods.removeAll(superInitMethods);
        for (MethodNode methodNode : classNode.methods) {
            if (Annotations.getVisible((MethodNode)methodNode, MagicInit.class) == null) continue;
            methodNode.name = "<init>";
            boolean initInvoke = false;
            for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
                if (abstractInsnNode.getOpcode() != 182 || !(abstractInsnNode instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (MixinUtil.containsMethodNode(thisInitMethods, methodInsnNode.name, methodInsnNode.desc)) {
                    methodInsnNode.setOpcode(183);
                    methodInsnNode.name = "<init>";
                    initInvoke = true;
                    break;
                }
                if (!MixinUtil.containsMethodNode(superInitMethods, methodInsnNode.name, methodInsnNode.desc)) continue;
                methodInsnNode.setOpcode(183);
                methodInsnNode.name = "<init>";
                methodInsnNode.owner = classNode.superName;
                initInvoke = true;
                break;
            }
            if (initInvoke) continue;
            methodNode.instructions.insert((AbstractInsnNode)new MethodInsnNode(183, classNode.superName, "<init>", "()V"));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 0));
            AnnotationNode info = Annotations.getVisible((MethodNode)methodNode, MixinMerged.class);
            if (info != null) continue;
            return;
        }
    }
}

