/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.impl.dependency.DependenciesContainer;
import top.hendrixshen.magiclib.impl.dependency.DependencyCheckResult;
import top.hendrixshen.magiclib.util.GsonUtil;
import top.hendrixshen.magiclib.util.JsonUtil;
import top.hendrixshen.magiclib.util.collect.InfoNode;

public class MiscUtil {
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Gson GSON = GsonUtil.GSON;

    @NotNull
    public static String getSystemLanguageCode() {
        return Locale.getDefault().toString().toLowerCase();
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static <T> void generateDependencyCheckMessage(@NotNull List<DependenciesContainer<T>> dependencies, InfoNode rootNode) {
        boolean first = true;
        boolean composite = false;
        InfoNode compositeNode = new InfoNode(null, I18n.tr("magiclib.dependency.label.composite"));
        for (DependenciesContainer<T> dependenciesContainer : dependencies) {
            boolean conflictSatisfied = dependenciesContainer.isConflictSatisfied();
            boolean requireSatisfied = dependenciesContainer.isRequireSatisfied();
            InfoNode orNode = null;
            if (first) {
                first = false;
            } else if (!conflictSatisfied || !requireSatisfied) {
                if (!composite) {
                    for (InfoNode child : rootNode.getChildren()) {
                        child.moveTo(compositeNode);
                    }
                    compositeNode.moveTo(rootNode);
                    composite = true;
                }
                orNode = new InfoNode(rootNode, I18n.tr("magiclib.dependency.label.or"));
            }
            if (!conflictSatisfied) {
                InfoNode conflictNode = new InfoNode(orNode == null ? rootNode : orNode, I18n.tr("magiclib.dependency.label.conflict"));
                for (DependencyCheckResult result : dependenciesContainer.checkConflict()) {
                    new InfoNode(conflictNode, result.getReason());
                }
            }
            if (requireSatisfied) continue;
            InfoNode requireNode = new InfoNode(orNode == null ? rootNode : orNode, I18n.tr("magiclib.dependency.label.require"));
            for (DependencyCheckResult result : dependenciesContainer.checkRequire()) {
                new InfoNode(requireNode, result.getReason());
            }
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static JsonObject readJson(@NotNull URL url) throws IOException {
        return JsonUtil.readJson(url);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void loadStringMapFromJson(InputStream inputStream, BiConsumer<String, String> biConsumer) {
        JsonUtil.loadStringMapFromJson(inputStream, biConsumer);
    }
}

