/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.platform;

import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

public enum PlatformType {
    ANY("any"),
    FABRIC("fabric"),
    FABRIC_LIKE("fabric_like"),
    FORGE("forge"),
    FORGE_LIKE("forge_like"),
    NEOFORGE("neoforge"),
    QUILT("quilt"),
    UNKNOWN("unknown");

    private final String name;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public boolean isForgeLike(PlatformType type) {
        return type == FORGE_LIKE || type == FORGE || type == NEOFORGE;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public boolean isFabricLike(PlatformType type) {
        return type == FABRIC_LIKE || type == FABRIC || type == QUILT;
    }

    public boolean isForgeLike() {
        return this.isForgeLike(this);
    }

    public boolean isFabricLike() {
        return this.isFabricLike(this);
    }

    public boolean matches(PlatformType type) {
        if (this == UNKNOWN || type == UNKNOWN) {
            return false;
        }
        if (this == ANY || type == ANY) {
            return true;
        }
        if (type == FABRIC_LIKE && this.isFabricLike() || this == FABRIC_LIKE && type.isFabricLike()) {
            return true;
        }
        if (type == FORGE_LIKE && this.isForgeLike() || this == FORGE_LIKE && type.isForgeLike()) {
            return true;
        }
        return type == this;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    private PlatformType(String name) {
        this.name = name;
    }
}

