/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.serializable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;

public interface JsonSaveAble {
    default public JsonObject dumpToJson() {
        JsonObject jsonObject = new JsonObject();
        this.dumpToJson(jsonObject);
        return jsonObject;
    }

    public void dumpToJson(@NotNull JsonObject var1);

    public void loadFromJson(@NotNull JsonObject var1);

    default public void loadFromJsonSafe(JsonObject jsonObject) {
        try {
            this.loadFromJson(jsonObject);
        }
        catch (Exception e) {
            MagicLib.getLogger().warn("Failed to load data of {} from json object {}: {}", (Object)this.getClass().getSimpleName(), (Object)jsonObject, (Object)e);
        }
    }

    default public <T extends Enum<T>> T getEnumSafe(@NotNull JsonObject jsonObject, String key, @NotNull T fallbackValue) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement != null && jsonElement.isJsonPrimitive()) {
            String jsonName = jsonElement.getAsString();
            try {
                return (T)Enum.valueOf(fallbackValue.getClass(), jsonName);
            }
            catch (Exception e) {
                MagicLib.getLogger().warn("Failed to load data of {} from json object {}: {}", (Object)this.getClass().getSimpleName(), (Object)jsonObject, (Object)e);
            }
        }
        return fallbackValue;
    }
}

