/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.event.minecraft.render;

import java.util.List;
import lombok.Generated;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fStack;
import top.hendrixshen.magiclib.api.compat.minecraft.util.ProfilerCompat;
import top.hendrixshen.magiclib.api.event.Event;
import top.hendrixshen.magiclib.api.event.minecraft.render.RenderLevelListener;
import top.hendrixshen.magiclib.api.render.context.RenderContext;
import top.hendrixshen.magiclib.impl.render.matrix.JomlMatrixStack;
import top.hendrixshen.magiclib.util.minecraft.render.RenderUtil;

public class RenderLevelEvent {
    private static LevelRenderContext fromInfo(Info info) {
        return LevelRenderContext.of(info.level, ((JomlMatrixStack)info.renderContext.getMatrixStack()).getRaw(), 0.0f);
    }

    public static class Info {
        @NotNull
        private final ClientLevel level;
        @NotNull
        private final top.hendrixshen.magiclib.api.render.context.LevelRenderContext renderContext;

        public static Info of(@NotNull ClientLevel level, @NotNull Matrix4fStack matrixStack) {
            return new Info(level, RenderContext.level(matrixStack));
        }

        @Generated
        private Info(@NotNull ClientLevel level, @NotNull top.hendrixshen.magiclib.api.render.context.LevelRenderContext renderContext) {
            if (level == null) {
                throw new NullPointerException("level is marked non-null but is null");
            }
            if (renderContext == null) {
                throw new NullPointerException("renderContext is marked non-null but is null");
            }
            this.level = level;
            this.renderContext = renderContext;
        }
    }

    public static class LevelRenderContext {
        private final ClientLevel level;
        private final RenderContext renderContext;

        @NotNull
        public static LevelRenderContext of(ClientLevel level, @NotNull Matrix4fStack matrixStack, float partialTicks) {
            return new LevelRenderContext(level, RenderContext.createWorldRenderContext(matrixStack));
        }

        @Generated
        private LevelRenderContext(ClientLevel level, RenderContext renderContext) {
            this.level = level;
            this.renderContext = renderContext;
        }
    }

    public static class PostRender
    implements Event<RenderLevelListener> {
        private final LevelRenderContext context;
        private final Info info;

        public PostRender(Info info) {
            this.info = info;
            this.context = RenderLevelEvent.fromInfo(info);
        }

        @Override
        public void dispatch(@NotNull List<RenderLevelListener> listeners) {
            ProfilerCompat.get().push("Magiclib#PostLevelRenderHook");
            for (RenderLevelListener listener : listeners) {
                try {
                    listener.postRenderLevel(this.info.level, this.info.renderContext);
                }
                catch (UnsupportedOperationException e) {
                    listener.postRenderLevel((Level)this.context.level, this.context.renderContext, RenderUtil.getPartialTick());
                }
            }
            ProfilerCompat.get().pop();
        }

        @Override
        public Class<RenderLevelListener> getListenerType() {
            return RenderLevelListener.class;
        }
    }

    public static class PreRender
    implements Event<RenderLevelListener> {
        private final LevelRenderContext context;
        private final Info info;

        public PreRender(Info info) {
            this.info = info;
            this.context = RenderLevelEvent.fromInfo(info);
        }

        @Override
        public void dispatch(@NotNull List<RenderLevelListener> listeners) {
            ProfilerCompat.get().push("Magiclib#PreLevelRenderHook");
            for (RenderLevelListener listener : listeners) {
                try {
                    listener.preRenderLevel(this.info.level, this.info.renderContext);
                }
                catch (UnsupportedOperationException e) {
                    listener.preRenderLevel((Level)this.context.level, this.context.renderContext, RenderUtil.getPartialTick());
                }
            }
            ProfilerCompat.get().pop();
        }

        @Override
        public Class<RenderLevelListener> getListenerType() {
            return RenderLevelListener.class;
        }
    }
}

